/*
 * Decompiled with CFR 0.152.
 */
package sop.cli.picocli;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import sop.cli.picocli.FileUtil;
import sop.exception.SOPGPException;

public class FileUtilTest {
    @BeforeAll
    public static void setup() {
        FileUtil.setEnvironmentVariableResolver((FileUtil.EnvironmentVariableResolver)new FileUtil.EnvironmentVariableResolver(){

            public String resolveEnvironmentVariable(String name) {
                if (name.equals("test123")) {
                    return "test321";
                }
                return null;
            }
        });
    }

    @Test
    public void getFile_ThrowsForNull() {
        Assertions.assertThrows(NullPointerException.class, () -> FileUtil.getFile(null));
    }

    @Test
    public void getFile_prfxEnvAlreadyExists() throws IOException {
        File tempFile = new File("@ENV:test");
        tempFile.createNewFile();
        tempFile.deleteOnExit();
        Assertions.assertThrows(SOPGPException.AmbiguousInput.class, () -> FileUtil.getFile((String)"@ENV:test"));
    }

    @Test
    public void getFile_EnvironmentVariable() {
        File file = FileUtil.getFile((String)"@ENV:test123");
        Assertions.assertEquals((Object)"test321", (Object)file.getName());
    }

    @Test
    public void getFile_nonExistentEnvVariable() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtil.getFile((String)"@ENV:INVALID"));
    }

    @Test
    public void getFile_prfxFdAlreadyExists() throws IOException {
        File tempFile = new File("@FD:1");
        tempFile.createNewFile();
        tempFile.deleteOnExit();
        Assertions.assertThrows(SOPGPException.AmbiguousInput.class, () -> FileUtil.getFile((String)"@FD:1"));
    }

    @Test
    public void getFile_prfxFdNotSupported() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtil.getFile((String)"@FD:2"));
    }

    @Test
    public void createNewFileOrThrow_throwsForNull() {
        Assertions.assertThrows(NullPointerException.class, () -> FileUtil.createNewFileOrThrow(null));
    }

    @Test
    public void createNewFileOrThrow_success() throws IOException {
        File dir = Files.createTempDirectory("test", new FileAttribute[0]).toFile();
        dir.deleteOnExit();
        File file = new File(dir, "file");
        Assertions.assertFalse((boolean)file.exists());
        FileUtil.createNewFileOrThrow((File)file);
        Assertions.assertTrue((boolean)file.exists());
    }

    @Test
    public void createNewFileOrThrow_alreadyExists() throws IOException {
        File dir = Files.createTempDirectory("test", new FileAttribute[0]).toFile();
        dir.deleteOnExit();
        File file = new File(dir, "file");
        FileUtil.createNewFileOrThrow((File)file);
        Assertions.assertTrue((boolean)file.exists());
        Assertions.assertThrows(SOPGPException.OutputExists.class, () -> FileUtil.createNewFileOrThrow((File)file));
    }

    @Test
    public void getFileInputStream_success() throws IOException {
        File dir = Files.createTempDirectory("test", new FileAttribute[0]).toFile();
        dir.deleteOnExit();
        File file = new File(dir, "file");
        FileUtil.createNewFileOrThrow((File)file);
        FileInputStream inputStream = FileUtil.getFileInputStream((String)file.getAbsolutePath());
        Assertions.assertNotNull((Object)inputStream);
    }

    @Test
    public void getFileInputStream_fileNotFound() throws IOException {
        File dir = Files.createTempDirectory("test", new FileAttribute[0]).toFile();
        dir.deleteOnExit();
        File file = new File(dir, "file");
        Assertions.assertThrows(SOPGPException.MissingInput.class, () -> FileUtil.getFileInputStream((String)file.getAbsolutePath()));
    }
}

