/*
 * Decompiled with CFR 0.152.
 */
package sop.cli.picocli.commands;

import com.ginsberg.junit.exit.ExpectSystemExitWithStatus;
import com.ginsberg.junit.exit.FailOnSystemExit;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import sop.Ready;
import sop.SOP;
import sop.cli.picocli.SopCLI;
import sop.enums.ArmorLabel;
import sop.exception.SOPGPException;
import sop.operation.Armor;

public class ArmorCmdTest {
    private Armor armor;
    private SOP sop;

    @BeforeEach
    public void mockComponents() throws SOPGPException.BadData {
        this.armor = (Armor)Mockito.mock(Armor.class);
        this.sop = (SOP)Mockito.mock(SOP.class);
        Mockito.when((Object)this.sop.armor()).thenReturn((Object)this.armor);
        Mockito.when((Object)this.armor.data((InputStream)ArgumentMatchers.any())).thenReturn((Object)ArmorCmdTest.nopReady());
        SopCLI.setSopInstance((SOP)this.sop);
    }

    @Test
    public void assertLabelIsNotCalledByDefault() throws SOPGPException.UnsupportedOption {
        SopCLI.main((String[])new String[]{"armor"});
        ((Armor)Mockito.verify((Object)this.armor, (VerificationMode)Mockito.never())).label((ArmorLabel)ArgumentMatchers.any());
    }

    @Test
    public void assertLabelIsCalledWhenFlaggedWithArgument() throws SOPGPException.UnsupportedOption {
        for (ArmorLabel label : ArmorLabel.values()) {
            SopCLI.main((String[])new String[]{"armor", "--label", label.name()});
            ((Armor)Mockito.verify((Object)this.armor, (VerificationMode)Mockito.times((int)1))).label(label);
        }
    }

    @Test
    public void assertDataIsAlwaysCalled() throws SOPGPException.BadData {
        SopCLI.main((String[])new String[]{"armor"});
        ((Armor)Mockito.verify((Object)this.armor, (VerificationMode)Mockito.times((int)1))).data((InputStream)ArgumentMatchers.any());
    }

    @Test
    @ExpectSystemExitWithStatus(value=37)
    public void assertThrowsForInvalidLabel() {
        SopCLI.main((String[])new String[]{"armor", "--label", "Invalid"});
    }

    @Test
    @ExpectSystemExitWithStatus(value=37)
    public void ifLabelsUnsupportedExit37() throws SOPGPException.UnsupportedOption {
        Mockito.when((Object)this.armor.label((ArmorLabel)ArgumentMatchers.any())).thenThrow(new Throwable[]{new SOPGPException.UnsupportedOption("Custom Armor labels are not supported.")});
        SopCLI.main((String[])new String[]{"armor", "--label", "Sig"});
    }

    @Test
    @ExpectSystemExitWithStatus(value=41)
    public void ifBadDataExit41() throws SOPGPException.BadData {
        Mockito.when((Object)this.armor.data((InputStream)ArgumentMatchers.any())).thenThrow(new Throwable[]{new SOPGPException.BadData((Throwable)new IOException())});
        SopCLI.main((String[])new String[]{"armor"});
    }

    @Test
    @FailOnSystemExit
    public void ifNoErrorsNoExit() {
        Mockito.when((Object)this.sop.armor()).thenReturn((Object)this.armor);
        SopCLI.main((String[])new String[]{"armor"});
    }

    private static Ready nopReady() {
        return new Ready(){

            public void writeTo(OutputStream outputStream) {
            }
        };
    }
}

