/*
 * Decompiled with CFR 0.152.
 */
package sop.cli.picocli.commands;

import com.ginsberg.junit.exit.ExpectSystemExitWithStatus;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import sop.Ready;
import sop.SOP;
import sop.cli.picocli.SopCLI;
import sop.exception.SOPGPException;
import sop.operation.Dearmor;

public class DearmorCmdTest {
    private SOP sop;
    private Dearmor dearmor;

    @BeforeEach
    public void mockComponents() throws IOException, SOPGPException.BadData {
        this.sop = (SOP)Mockito.mock(SOP.class);
        this.dearmor = (Dearmor)Mockito.mock(Dearmor.class);
        Mockito.when((Object)this.dearmor.data((InputStream)ArgumentMatchers.any())).thenReturn((Object)DearmorCmdTest.nopReady());
        Mockito.when((Object)this.sop.dearmor()).thenReturn((Object)this.dearmor);
        SopCLI.setSopInstance((SOP)this.sop);
    }

    private static Ready nopReady() {
        return new Ready(){

            public void writeTo(OutputStream outputStream) {
            }
        };
    }

    @Test
    public void assertDataIsCalled() throws IOException, SOPGPException.BadData {
        SopCLI.main((String[])new String[]{"dearmor"});
        ((Dearmor)Mockito.verify((Object)this.dearmor, (VerificationMode)Mockito.times((int)1))).data((InputStream)ArgumentMatchers.any());
    }

    @Test
    @ExpectSystemExitWithStatus(value=41)
    public void assertBadDataCausesExit41() throws IOException, SOPGPException.BadData {
        Mockito.when((Object)this.dearmor.data((InputStream)ArgumentMatchers.any())).thenThrow(new Throwable[]{new SOPGPException.BadData((Throwable)new IOException("invalid armor"))});
        SopCLI.main((String[])new String[]{"dearmor"});
    }
}

