/*
 * Decompiled with CFR 0.152.
 */
package sop.cli.picocli.commands;

import com.ginsberg.junit.exit.ExpectSystemExitWithStatus;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Date;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import sop.DecryptionResult;
import sop.ReadyWithResult;
import sop.SOP;
import sop.SessionKey;
import sop.Verification;
import sop.cli.picocli.DateParser;
import sop.cli.picocli.SopCLI;
import sop.exception.SOPGPException;
import sop.operation.Decrypt;
import sop.util.HexUtil;
import sop.util.UTCUtil;

public class DecryptCmdTest {
    private Decrypt decrypt;

    @BeforeEach
    public void mockComponents() throws SOPGPException.UnsupportedOption, SOPGPException.MissingArg, SOPGPException.BadData, SOPGPException.KeyIsProtected, SOPGPException.UnsupportedAsymmetricAlgo, SOPGPException.PasswordNotHumanReadable, SOPGPException.CannotDecrypt {
        SOP sop = (SOP)Mockito.mock(SOP.class);
        this.decrypt = (Decrypt)Mockito.mock(Decrypt.class);
        Mockito.when((Object)this.decrypt.verifyNotAfter((Date)ArgumentMatchers.any())).thenReturn((Object)this.decrypt);
        Mockito.when((Object)this.decrypt.verifyNotBefore((Date)ArgumentMatchers.any())).thenReturn((Object)this.decrypt);
        Mockito.when((Object)this.decrypt.withPassword((String)ArgumentMatchers.any())).thenReturn((Object)this.decrypt);
        Mockito.when((Object)this.decrypt.withSessionKey((SessionKey)ArgumentMatchers.any())).thenReturn((Object)this.decrypt);
        Mockito.when((Object)this.decrypt.withKey((InputStream)ArgumentMatchers.any())).thenReturn((Object)this.decrypt);
        Mockito.when((Object)this.decrypt.ciphertext((InputStream)ArgumentMatchers.any())).thenReturn(DecryptCmdTest.nopReadyWithResult());
        Mockito.when((Object)sop.decrypt()).thenReturn((Object)this.decrypt);
        SopCLI.setSopInstance((SOP)sop);
    }

    private static ReadyWithResult<DecryptionResult> nopReadyWithResult() {
        return new ReadyWithResult<DecryptionResult>(){

            public DecryptionResult writeTo(OutputStream outputStream) {
                return new DecryptionResult(null, Collections.emptyList());
            }
        };
    }

    @Test
    @ExpectSystemExitWithStatus(value=19)
    public void missingArgumentsExceptionCausesExit19() throws SOPGPException.MissingArg, SOPGPException.BadData, SOPGPException.CannotDecrypt {
        Mockito.when((Object)this.decrypt.ciphertext((InputStream)ArgumentMatchers.any())).thenThrow(new Throwable[]{new SOPGPException.MissingArg("Missing arguments.")});
        SopCLI.main((String[])new String[]{"decrypt"});
    }

    @Test
    @ExpectSystemExitWithStatus(value=41)
    public void badDataExceptionCausesExit41() throws SOPGPException.MissingArg, SOPGPException.BadData, SOPGPException.CannotDecrypt {
        Mockito.when((Object)this.decrypt.ciphertext((InputStream)ArgumentMatchers.any())).thenThrow(new Throwable[]{new SOPGPException.BadData((Throwable)new IOException())});
        SopCLI.main((String[])new String[]{"decrypt"});
    }

    @Test
    @ExpectSystemExitWithStatus(value=31)
    public void assertNotHumanReadablePasswordCausesExit31() throws SOPGPException.PasswordNotHumanReadable, SOPGPException.UnsupportedOption {
        Mockito.when((Object)this.decrypt.withPassword((String)ArgumentMatchers.any())).thenThrow(new Throwable[]{new SOPGPException.PasswordNotHumanReadable()});
        SopCLI.main((String[])new String[]{"decrypt", "--with-password", "pretendThisIsNotReadable"});
    }

    @Test
    public void assertWithPasswordPassesPasswordDown() throws SOPGPException.PasswordNotHumanReadable, SOPGPException.UnsupportedOption {
        SopCLI.main((String[])new String[]{"decrypt", "--with-password", "orange"});
        ((Decrypt)Mockito.verify((Object)this.decrypt, (VerificationMode)Mockito.times((int)1))).withPassword("orange");
    }

    @Test
    @ExpectSystemExitWithStatus(value=37)
    public void assertUnsupportedWithPasswordCausesExit37() throws SOPGPException.PasswordNotHumanReadable, SOPGPException.UnsupportedOption {
        Mockito.when((Object)this.decrypt.withPassword((String)ArgumentMatchers.any())).thenThrow(new Throwable[]{new SOPGPException.UnsupportedOption("Decrypting with password not supported.")});
        SopCLI.main((String[])new String[]{"decrypt", "--with-password", "swordfish"});
    }

    @Test
    public void assertDefaultTimeRangesAreUsedIfNotOverwritten() throws SOPGPException.UnsupportedOption {
        Date now = new Date();
        SopCLI.main((String[])new String[]{"decrypt"});
        ((Decrypt)Mockito.verify((Object)this.decrypt, (VerificationMode)Mockito.times((int)1))).verifyNotBefore(DateParser.BEGINNING_OF_TIME);
        ((Decrypt)Mockito.verify((Object)this.decrypt, (VerificationMode)Mockito.times((int)1))).verifyNotAfter((Date)ArgumentMatchers.argThat(argument -> Math.abs(now.getTime() - argument.getTime()) <= 1000L));
    }

    @Test
    public void assertVerifyNotAfterAndBeforeDashResultsInMaxTimeRange() throws SOPGPException.UnsupportedOption {
        SopCLI.main((String[])new String[]{"decrypt", "--not-before", "-", "--not-after", "-"});
        ((Decrypt)Mockito.verify((Object)this.decrypt, (VerificationMode)Mockito.times((int)1))).verifyNotBefore(DateParser.BEGINNING_OF_TIME);
        ((Decrypt)Mockito.verify((Object)this.decrypt, (VerificationMode)Mockito.times((int)1))).verifyNotAfter(DateParser.END_OF_TIME);
    }

    @Test
    public void assertVerifyNotAfterAndBeforeNowResultsInMinTimeRange() throws SOPGPException.UnsupportedOption {
        Date now = new Date();
        ArgumentMatcher isMaxOneSecOff = argument -> Math.abs(now.getTime() - argument.getTime()) <= 1000L;
        SopCLI.main((String[])new String[]{"decrypt", "--not-before", "now", "--not-after", "now"});
        ((Decrypt)Mockito.verify((Object)this.decrypt, (VerificationMode)Mockito.times((int)1))).verifyNotAfter((Date)ArgumentMatchers.argThat((ArgumentMatcher)isMaxOneSecOff));
        ((Decrypt)Mockito.verify((Object)this.decrypt, (VerificationMode)Mockito.times((int)1))).verifyNotBefore((Date)ArgumentMatchers.argThat((ArgumentMatcher)isMaxOneSecOff));
    }

    @Test
    @ExpectSystemExitWithStatus(value=1)
    public void assertMalformedDateInNotBeforeCausesExit1() {
        SopCLI.main((String[])new String[]{"decrypt", "--not-before", "invalid"});
    }

    @Test
    @ExpectSystemExitWithStatus(value=1)
    public void assertMalformedDateInNotAfterCausesExit1() {
        SopCLI.main((String[])new String[]{"decrypt", "--not-after", "invalid"});
    }

    @Test
    @ExpectSystemExitWithStatus(value=37)
    public void assertUnsupportedNotAfterCausesExit37() throws SOPGPException.UnsupportedOption {
        Mockito.when((Object)this.decrypt.verifyNotAfter((Date)ArgumentMatchers.any())).thenThrow(new Throwable[]{new SOPGPException.UnsupportedOption("Setting upper signature date boundary not supported.")});
        SopCLI.main((String[])new String[]{"decrypt", "--not-after", "now"});
    }

    @Test
    @ExpectSystemExitWithStatus(value=37)
    public void assertUnsupportedNotBeforeCausesExit37() throws SOPGPException.UnsupportedOption {
        Mockito.when((Object)this.decrypt.verifyNotBefore((Date)ArgumentMatchers.any())).thenThrow(new Throwable[]{new SOPGPException.UnsupportedOption("Setting lower signature date boundary not supported.")});
        SopCLI.main((String[])new String[]{"decrypt", "--not-before", "now"});
    }

    @Test
    @ExpectSystemExitWithStatus(value=59)
    public void assertExistingSessionKeyOutFileCausesExit59() throws IOException {
        File tempFile = File.createTempFile("existing-session-key-", ".tmp");
        tempFile.deleteOnExit();
        SopCLI.main((String[])new String[]{"decrypt", "--session-key-out", tempFile.getAbsolutePath()});
    }

    @Test
    @ExpectSystemExitWithStatus(value=37)
    public void assertWhenSessionKeyCannotBeExtractedExit37() throws IOException {
        Path tempDir = Files.createTempDirectory("session-key-out-dir", new FileAttribute[0]);
        File tempFile = new File(tempDir.toFile(), "session-key");
        tempFile.deleteOnExit();
        SopCLI.main((String[])new String[]{"decrypt", "--session-key-out", tempFile.getAbsolutePath()});
    }

    @Test
    public void assertSessionKeyIsProperlyWrittenToSessionKeyFile() throws SOPGPException.CannotDecrypt, SOPGPException.MissingArg, SOPGPException.BadData, IOException {
        final byte[] key = "C7CBDAF42537776F12509B5168793C26B93294E5ABDFA73224FB0177123E9137".getBytes(StandardCharsets.UTF_8);
        Mockito.when((Object)this.decrypt.ciphertext((InputStream)ArgumentMatchers.any())).thenReturn((Object)new ReadyWithResult<DecryptionResult>(){

            public DecryptionResult writeTo(OutputStream outputStream) {
                return new DecryptionResult(new SessionKey(9, key), Collections.emptyList());
            }
        });
        Path tempDir = Files.createTempDirectory("session-key-out-dir", new FileAttribute[0]);
        File tempFile = new File(tempDir.toFile(), "session-key");
        tempFile.deleteOnExit();
        SopCLI.main((String[])new String[]{"decrypt", "--session-key-out", tempFile.getAbsolutePath()});
        ByteArrayOutputStream bytesInFile = new ByteArrayOutputStream();
        try (FileInputStream fileIn = new FileInputStream(tempFile);){
            byte[] buf = new byte[32];
            int read = fileIn.read(buf);
            while (read != -1) {
                bytesInFile.write(buf, 0, read);
                read = fileIn.read(buf);
            }
        }
        byte[] algAndKey = new byte[key.length + 1];
        algAndKey[0] = 9;
        System.arraycopy(key, 0, algAndKey, 1, key.length);
        Assertions.assertArrayEquals((byte[])algAndKey, (byte[])bytesInFile.toByteArray());
    }

    @Test
    @ExpectSystemExitWithStatus(value=29)
    public void assertUnableToDecryptExceptionResultsInExit29() throws SOPGPException.CannotDecrypt, SOPGPException.MissingArg, SOPGPException.BadData {
        Mockito.when((Object)this.decrypt.ciphertext((InputStream)ArgumentMatchers.any())).thenThrow(new Throwable[]{new SOPGPException.CannotDecrypt()});
        SopCLI.main((String[])new String[]{"decrypt"});
    }

    @Test
    @ExpectSystemExitWithStatus(value=3)
    public void assertNoSignatureExceptionCausesExit3() throws SOPGPException.CannotDecrypt, SOPGPException.MissingArg, SOPGPException.BadData {
        Mockito.when((Object)this.decrypt.ciphertext((InputStream)ArgumentMatchers.any())).thenReturn((Object)new ReadyWithResult<DecryptionResult>(){

            public DecryptionResult writeTo(OutputStream outputStream) throws SOPGPException.NoSignature {
                throw new SOPGPException.NoSignature();
            }
        });
        SopCLI.main((String[])new String[]{"decrypt"});
    }

    @Test
    @ExpectSystemExitWithStatus(value=41)
    public void badDataInVerifyWithCausesExit41() throws IOException, SOPGPException.BadData {
        Mockito.when((Object)this.decrypt.verifyWithCert((InputStream)ArgumentMatchers.any())).thenThrow(new Throwable[]{new SOPGPException.BadData((Throwable)new IOException())});
        File tempFile = File.createTempFile("verify-with-", ".tmp");
        SopCLI.main((String[])new String[]{"decrypt", "--verify-with", tempFile.getAbsolutePath()});
    }

    @Test
    @ExpectSystemExitWithStatus(value=61)
    public void unexistentCertFileCausesExit61() {
        SopCLI.main((String[])new String[]{"decrypt", "--verify-with", "invalid"});
    }

    @Test
    @ExpectSystemExitWithStatus(value=59)
    public void existingVerifyOutCausesExit59() throws IOException {
        File certFile = File.createTempFile("existing-verify-out-cert", ".asc");
        File existingVerifyOut = File.createTempFile("existing-verify-out", ".tmp");
        SopCLI.main((String[])new String[]{"decrypt", "--verify-out", existingVerifyOut.getAbsolutePath(), "--verify-with", certFile.getAbsolutePath()});
    }

    @Test
    public void verifyOutIsProperlyWritten() throws IOException, SOPGPException.CannotDecrypt, SOPGPException.MissingArg, SOPGPException.BadData {
        File certFile = File.createTempFile("verify-out-cert", ".asc");
        File verifyOut = new File(certFile.getParent(), "verify-out.txt");
        if (verifyOut.exists()) {
            verifyOut.delete();
        }
        verifyOut.deleteOnExit();
        final Date date = UTCUtil.parseUTCDate((String)"2021-07-11T20:58:23Z");
        Mockito.when((Object)this.decrypt.ciphertext((InputStream)ArgumentMatchers.any())).thenReturn((Object)new ReadyWithResult<DecryptionResult>(){

            public DecryptionResult writeTo(OutputStream outputStream) {
                return new DecryptionResult(null, Collections.singletonList(new Verification(date, "1B66A707819A920925BC6777C3E0AFC0B2DFF862", "C8CD564EBF8D7BBA90611D8D071773658BF6BF86")));
            }
        });
        SopCLI.main((String[])new String[]{"decrypt", "--verify-out", verifyOut.getAbsolutePath(), "--verify-with", certFile.getAbsolutePath()});
        try (BufferedReader reader = new BufferedReader(new FileReader(verifyOut));){
            String line = reader.readLine();
            Assertions.assertEquals((Object)"2021-07-11T20:58:23Z 1B66A707819A920925BC6777C3E0AFC0B2DFF862 C8CD564EBF8D7BBA90611D8D071773658BF6BF86", (Object)line);
        }
    }

    @Test
    public void assertWithSessionKeyIsPassedDown() throws SOPGPException.UnsupportedOption {
        SessionKey key1 = new SessionKey(9, HexUtil.hexToBytes((String)"C7CBDAF42537776F12509B5168793C26B93294E5ABDFA73224FB0177123E9137"));
        SessionKey key2 = new SessionKey(9, HexUtil.hexToBytes((String)"FCA4BEAF687F48059CACC14FB019125CD57392BAB7037C707835925CBF9F7BCD"));
        SopCLI.main((String[])new String[]{"decrypt", "--with-session-key", "9:C7CBDAF42537776F12509B5168793C26B93294E5ABDFA73224FB0177123E9137", "--with-session-key", "9:FCA4BEAF687F48059CACC14FB019125CD57392BAB7037C707835925CBF9F7BCD"});
        ((Decrypt)Mockito.verify((Object)this.decrypt)).withSessionKey(key1);
        ((Decrypt)Mockito.verify((Object)this.decrypt)).withSessionKey(key2);
    }

    @Test
    @ExpectSystemExitWithStatus(value=1)
    public void assertMalformedSessionKeysResultInExit1() {
        SopCLI.main((String[])new String[]{"decrypt", "--with-session-key", "C7CBDAF42537776F12509B5168793C26B93294E5ABDFA73224FB0177123E9137"});
    }

    @Test
    @ExpectSystemExitWithStatus(value=41)
    public void assertBadDataInKeysResultsInExit41() throws SOPGPException.KeyIsProtected, SOPGPException.UnsupportedAsymmetricAlgo, SOPGPException.BadData, IOException {
        Mockito.when((Object)this.decrypt.withKey((InputStream)ArgumentMatchers.any())).thenThrow(new Throwable[]{new SOPGPException.BadData((Throwable)new IOException())});
        File tempKeyFile = File.createTempFile("key-", ".tmp");
        SopCLI.main((String[])new String[]{"decrypt", tempKeyFile.getAbsolutePath()});
    }

    @Test
    @ExpectSystemExitWithStatus(value=61)
    public void assertKeyFileNotFoundCausesExit61() {
        SopCLI.main((String[])new String[]{"decrypt", "nonexistent-key"});
    }

    @Test
    @ExpectSystemExitWithStatus(value=67)
    public void assertProtectedKeyCausesExit67() throws IOException, SOPGPException.KeyIsProtected, SOPGPException.UnsupportedAsymmetricAlgo, SOPGPException.BadData {
        Mockito.when((Object)this.decrypt.withKey((InputStream)ArgumentMatchers.any())).thenThrow(new Throwable[]{new SOPGPException.KeyIsProtected()});
        File tempKeyFile = File.createTempFile("key-", ".tmp");
        SopCLI.main((String[])new String[]{"decrypt", tempKeyFile.getAbsolutePath()});
    }

    @Test
    @ExpectSystemExitWithStatus(value=13)
    public void assertUnsupportedAlgorithmExceptionCausesExit13() throws SOPGPException.KeyIsProtected, SOPGPException.UnsupportedAsymmetricAlgo, SOPGPException.BadData, IOException {
        Mockito.when((Object)this.decrypt.withKey((InputStream)ArgumentMatchers.any())).thenThrow(new Throwable[]{new SOPGPException.UnsupportedAsymmetricAlgo("Unsupported asymmetric algorithm.", (Throwable)new IOException())});
        File tempKeyFile = File.createTempFile("key-", ".tmp");
        SopCLI.main((String[])new String[]{"decrypt", tempKeyFile.getAbsolutePath()});
    }

    @Test
    @ExpectSystemExitWithStatus(value=23)
    public void verifyOutWithoutVerifyWithCausesExit23() {
        SopCLI.main((String[])new String[]{"decrypt", "--verify-out", "out.file"});
    }
}

