/*
 * Decompiled with CFR 0.152.
 */
package sop.cli.picocli.commands;

import com.ginsberg.junit.exit.ExpectSystemExitWithStatus;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import sop.Ready;
import sop.SOP;
import sop.cli.picocli.SopCLI;
import sop.enums.EncryptAs;
import sop.exception.SOPGPException;
import sop.operation.Encrypt;

public class EncryptCmdTest {
    Encrypt encrypt;

    @BeforeEach
    public void mockComponents() throws IOException {
        this.encrypt = (Encrypt)Mockito.mock(Encrypt.class);
        Mockito.when((Object)this.encrypt.plaintext((InputStream)ArgumentMatchers.any())).thenReturn((Object)new Ready(){

            public void writeTo(OutputStream outputStream) {
            }
        });
        SOP sop = (SOP)Mockito.mock(SOP.class);
        Mockito.when((Object)sop.encrypt()).thenReturn((Object)this.encrypt);
        SopCLI.setSopInstance((SOP)sop);
    }

    @Test
    @ExpectSystemExitWithStatus(value=19)
    public void missingBothPasswordAndCertFileCauseExit19() {
        SopCLI.main((String[])new String[]{"encrypt", "--no-armor"});
    }

    @Test
    @ExpectSystemExitWithStatus(value=37)
    public void as_unsupportedEncryptAsCausesExit37() throws SOPGPException.UnsupportedOption {
        Mockito.when((Object)this.encrypt.mode((EncryptAs)ArgumentMatchers.any())).thenThrow(new Throwable[]{new SOPGPException.UnsupportedOption("Setting encryption mode not supported.")});
        SopCLI.main((String[])new String[]{"encrypt", "--as", "Binary"});
    }

    @Test
    @ExpectSystemExitWithStatus(value=37)
    public void as_invalidModeOptionCausesExit37() {
        SopCLI.main((String[])new String[]{"encrypt", "--as", "invalid"});
    }

    @Test
    public void as_modeIsPassedDown() throws SOPGPException.UnsupportedOption {
        for (EncryptAs mode : EncryptAs.values()) {
            SopCLI.main((String[])new String[]{"encrypt", "--as", mode.name(), "--with-password", "0rbit"});
            ((Encrypt)Mockito.verify((Object)this.encrypt, (VerificationMode)Mockito.times((int)1))).mode(mode);
        }
    }

    @Test
    @ExpectSystemExitWithStatus(value=31)
    public void withPassword_notHumanReadablePasswordCausesExit31() throws SOPGPException.PasswordNotHumanReadable, SOPGPException.UnsupportedOption {
        Mockito.when((Object)this.encrypt.withPassword("pretendThisIsNotReadable")).thenThrow(new Throwable[]{new SOPGPException.PasswordNotHumanReadable()});
        SopCLI.main((String[])new String[]{"encrypt", "--with-password", "pretendThisIsNotReadable"});
    }

    @Test
    @ExpectSystemExitWithStatus(value=37)
    public void withPassword_unsupportedWithPasswordCausesExit37() throws SOPGPException.PasswordNotHumanReadable, SOPGPException.UnsupportedOption {
        Mockito.when((Object)this.encrypt.withPassword((String)ArgumentMatchers.any())).thenThrow(new Throwable[]{new SOPGPException.UnsupportedOption("Encrypting with password not supported.")});
        SopCLI.main((String[])new String[]{"encrypt", "--with-password", "orange"});
    }

    @Test
    public void signWith_multipleTimesGetPassedDown() throws IOException, SOPGPException.KeyIsProtected, SOPGPException.UnsupportedAsymmetricAlgo, SOPGPException.CertCannotSign, SOPGPException.BadData {
        File keyFile1 = File.createTempFile("sign-with-1-", ".asc");
        File keyFile2 = File.createTempFile("sign-with-2-", ".asc");
        SopCLI.main((String[])new String[]{"encrypt", "--with-password", "password", "--sign-with", keyFile1.getAbsolutePath(), "--sign-with", keyFile2.getAbsolutePath()});
        ((Encrypt)Mockito.verify((Object)this.encrypt, (VerificationMode)Mockito.times((int)2))).signWith((InputStream)ArgumentMatchers.any());
    }

    @Test
    @ExpectSystemExitWithStatus(value=61)
    public void signWith_nonExistentKeyFileCausesExit61() {
        SopCLI.main((String[])new String[]{"encrypt", "--with-password", "admin", "--sign-with", "nonExistent.asc"});
    }

    @Test
    @ExpectSystemExitWithStatus(value=67)
    public void signWith_keyIsProtectedCausesExit67() throws SOPGPException.KeyIsProtected, SOPGPException.UnsupportedAsymmetricAlgo, SOPGPException.CertCannotSign, SOPGPException.BadData, IOException {
        Mockito.when((Object)this.encrypt.signWith((InputStream)ArgumentMatchers.any())).thenThrow(new Throwable[]{new SOPGPException.KeyIsProtected()});
        File keyFile = File.createTempFile("sign-with", ".asc");
        SopCLI.main((String[])new String[]{"encrypt", "--sign-with", keyFile.getAbsolutePath(), "--with-password", "starship"});
    }

    @Test
    @ExpectSystemExitWithStatus(value=13)
    public void signWith_unsupportedAsymmetricAlgoCausesExit13() throws SOPGPException.KeyIsProtected, SOPGPException.UnsupportedAsymmetricAlgo, SOPGPException.CertCannotSign, SOPGPException.BadData, IOException {
        Mockito.when((Object)this.encrypt.signWith((InputStream)ArgumentMatchers.any())).thenThrow(new Throwable[]{new SOPGPException.UnsupportedAsymmetricAlgo("Unsupported asymmetric algorithm.", (Throwable)new Exception())});
        File keyFile = File.createTempFile("sign-with", ".asc");
        SopCLI.main((String[])new String[]{"encrypt", "--with-password", "123456", "--sign-with", keyFile.getAbsolutePath()});
    }

    @Test
    @ExpectSystemExitWithStatus(value=1)
    public void signWith_certCannotSignCausesExit1() throws IOException, SOPGPException.KeyIsProtected, SOPGPException.UnsupportedAsymmetricAlgo, SOPGPException.CertCannotSign, SOPGPException.BadData {
        Mockito.when((Object)this.encrypt.signWith((InputStream)ArgumentMatchers.any())).thenThrow(new Throwable[]{new SOPGPException.CertCannotSign()});
        File keyFile = File.createTempFile("sign-with", ".asc");
        SopCLI.main((String[])new String[]{"encrypt", "--with-password", "dragon", "--sign-with", keyFile.getAbsolutePath()});
    }

    @Test
    @ExpectSystemExitWithStatus(value=41)
    public void signWith_badDataCausesExit41() throws SOPGPException.KeyIsProtected, SOPGPException.UnsupportedAsymmetricAlgo, SOPGPException.CertCannotSign, SOPGPException.BadData, IOException {
        Mockito.when((Object)this.encrypt.signWith((InputStream)ArgumentMatchers.any())).thenThrow(new Throwable[]{new SOPGPException.BadData((Throwable)new IOException())});
        File keyFile = File.createTempFile("sign-with", ".asc");
        SopCLI.main((String[])new String[]{"encrypt", "--with-password", "orange", "--sign-with", keyFile.getAbsolutePath()});
    }

    @Test
    @ExpectSystemExitWithStatus(value=61)
    public void cert_nonExistentCertFileCausesExit61() {
        SopCLI.main((String[])new String[]{"encrypt", "invalid.asc"});
    }

    @Test
    @ExpectSystemExitWithStatus(value=13)
    public void cert_unsupportedAsymmetricAlgorithmCausesExit13() throws IOException, SOPGPException.UnsupportedAsymmetricAlgo, SOPGPException.CertCannotEncrypt, SOPGPException.BadData {
        Mockito.when((Object)this.encrypt.withCert((InputStream)ArgumentMatchers.any())).thenThrow(new Throwable[]{new SOPGPException.UnsupportedAsymmetricAlgo("Unsupported asymmetric algorithm.", (Throwable)new Exception())});
        File certFile = File.createTempFile("cert", ".asc");
        SopCLI.main((String[])new String[]{"encrypt", certFile.getAbsolutePath()});
    }

    @Test
    @ExpectSystemExitWithStatus(value=17)
    public void cert_certCannotEncryptCausesExit17() throws IOException, SOPGPException.UnsupportedAsymmetricAlgo, SOPGPException.CertCannotEncrypt, SOPGPException.BadData {
        Mockito.when((Object)this.encrypt.withCert((InputStream)ArgumentMatchers.any())).thenThrow(new Throwable[]{new SOPGPException.CertCannotEncrypt("Certificate cannot encrypt.", (Throwable)new Exception())});
        File certFile = File.createTempFile("cert", ".asc");
        SopCLI.main((String[])new String[]{"encrypt", certFile.getAbsolutePath()});
    }

    @Test
    @ExpectSystemExitWithStatus(value=41)
    public void cert_badDataCausesExit41() throws IOException, SOPGPException.UnsupportedAsymmetricAlgo, SOPGPException.CertCannotEncrypt, SOPGPException.BadData {
        Mockito.when((Object)this.encrypt.withCert((InputStream)ArgumentMatchers.any())).thenThrow(new Throwable[]{new SOPGPException.BadData((Throwable)new IOException())});
        File certFile = File.createTempFile("cert", ".asc");
        SopCLI.main((String[])new String[]{"encrypt", certFile.getAbsolutePath()});
    }

    @Test
    public void noArmor_notCalledByDefault() {
        SopCLI.main((String[])new String[]{"encrypt", "--with-password", "clownfish"});
        ((Encrypt)Mockito.verify((Object)this.encrypt, (VerificationMode)Mockito.never())).noArmor();
    }

    @Test
    public void noArmor_callGetsPassedDown() {
        SopCLI.main((String[])new String[]{"encrypt", "--with-password", "monkey", "--no-armor"});
        ((Encrypt)Mockito.verify((Object)this.encrypt, (VerificationMode)Mockito.times((int)1))).noArmor();
    }

    @Test
    @ExpectSystemExitWithStatus(value=1)
    public void writeTo_ioExceptionCausesExit1() throws IOException {
        Mockito.when((Object)this.encrypt.plaintext((InputStream)ArgumentMatchers.any())).thenReturn((Object)new Ready(){

            public void writeTo(OutputStream outputStream) throws IOException {
                throw new IOException();
            }
        });
        SopCLI.main((String[])new String[]{"encrypt", "--with-password", "wildcat"});
    }
}

