/*
 * Decompiled with CFR 0.152.
 */
package sop.cli.picocli.commands;

import com.ginsberg.junit.exit.ExpectSystemExitWithStatus;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import sop.Ready;
import sop.SOP;
import sop.cli.picocli.SopCLI;
import sop.exception.SOPGPException;
import sop.operation.ExtractCert;

public class ExtractCertCmdTest {
    ExtractCert extractCert;

    @BeforeEach
    public void mockComponents() throws IOException, SOPGPException.BadData {
        this.extractCert = (ExtractCert)Mockito.mock(ExtractCert.class);
        Mockito.when((Object)this.extractCert.key((InputStream)ArgumentMatchers.any())).thenReturn((Object)new Ready(){

            public void writeTo(OutputStream outputStream) {
            }
        });
        SOP sop = (SOP)Mockito.mock(SOP.class);
        Mockito.when((Object)sop.extractCert()).thenReturn((Object)this.extractCert);
        SopCLI.setSopInstance((SOP)sop);
    }

    @Test
    public void noArmor_notCalledByDefault() {
        SopCLI.main((String[])new String[]{"extract-cert"});
        ((ExtractCert)Mockito.verify((Object)this.extractCert, (VerificationMode)Mockito.never())).noArmor();
    }

    @Test
    public void noArmor_passedDown() {
        SopCLI.main((String[])new String[]{"extract-cert", "--no-armor"});
        ((ExtractCert)Mockito.verify((Object)this.extractCert, (VerificationMode)Mockito.times((int)1))).noArmor();
    }

    @Test
    @ExpectSystemExitWithStatus(value=1)
    public void key_ioExceptionCausesExit1() throws IOException, SOPGPException.BadData {
        Mockito.when((Object)this.extractCert.key((InputStream)ArgumentMatchers.any())).thenReturn((Object)new Ready(){

            public void writeTo(OutputStream outputStream) throws IOException {
                throw new IOException();
            }
        });
        SopCLI.main((String[])new String[]{"extract-cert"});
    }

    @Test
    @ExpectSystemExitWithStatus(value=41)
    public void key_badDataCausesExit41() throws IOException, SOPGPException.BadData {
        Mockito.when((Object)this.extractCert.key((InputStream)ArgumentMatchers.any())).thenThrow(new Throwable[]{new SOPGPException.BadData((Throwable)new IOException())});
        SopCLI.main((String[])new String[]{"extract-cert"});
    }
}

