/*
 * Decompiled with CFR 0.152.
 */
package sop.cli.picocli.commands;

import com.ginsberg.junit.exit.ExpectSystemExitWithStatus;
import java.io.IOException;
import java.io.OutputStream;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import sop.Ready;
import sop.SOP;
import sop.cli.picocli.SopCLI;
import sop.exception.SOPGPException;
import sop.operation.GenerateKey;

public class GenerateKeyCmdTest {
    GenerateKey generateKey;

    @BeforeEach
    public void mockComponents() throws SOPGPException.UnsupportedAsymmetricAlgo, SOPGPException.MissingArg, IOException {
        this.generateKey = (GenerateKey)Mockito.mock(GenerateKey.class);
        Mockito.when((Object)this.generateKey.generate()).thenReturn((Object)new Ready(){

            public void writeTo(OutputStream outputStream) {
            }
        });
        SOP sop = (SOP)Mockito.mock(SOP.class);
        Mockito.when((Object)sop.generateKey()).thenReturn((Object)this.generateKey);
        SopCLI.setSopInstance((SOP)sop);
    }

    @Test
    public void noArmor_notCalledByDefault() {
        SopCLI.main((String[])new String[]{"generate-key", "Alice"});
        ((GenerateKey)Mockito.verify((Object)this.generateKey, (VerificationMode)Mockito.never())).noArmor();
    }

    @Test
    public void noArmor_passedDown() {
        SopCLI.main((String[])new String[]{"generate-key", "--no-armor", "Alice"});
        ((GenerateKey)Mockito.verify((Object)this.generateKey, (VerificationMode)Mockito.times((int)1))).noArmor();
    }

    @Test
    public void userId_multipleUserIdsPassedDownInProperOrder() {
        SopCLI.main((String[])new String[]{"generate-key", "Alice <alice@pgpainless.org>", "Bob <bob@pgpainless.org>"});
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.generateKey});
        ((GenerateKey)inOrder.verify((Object)this.generateKey)).userId("Alice <alice@pgpainless.org>");
        ((GenerateKey)inOrder.verify((Object)this.generateKey)).userId("Bob <bob@pgpainless.org>");
        ((GenerateKey)Mockito.verify((Object)this.generateKey, (VerificationMode)Mockito.times((int)2))).userId((String)ArgumentMatchers.any());
    }

    @Test
    @ExpectSystemExitWithStatus(value=19)
    public void missingArgumentCausesExit19() throws SOPGPException.UnsupportedAsymmetricAlgo, SOPGPException.MissingArg, IOException {
        Mockito.when((Object)this.generateKey.generate()).thenThrow(new Throwable[]{new SOPGPException.MissingArg("Missing user-id.")});
        SopCLI.main((String[])new String[]{"generate-key"});
    }

    @Test
    @ExpectSystemExitWithStatus(value=13)
    public void unsupportedAsymmetricAlgorithmCausesExit13() throws SOPGPException.UnsupportedAsymmetricAlgo, SOPGPException.MissingArg, IOException {
        Mockito.when((Object)this.generateKey.generate()).thenThrow(new Throwable[]{new SOPGPException.UnsupportedAsymmetricAlgo("Unsupported asymmetric algorithm.", (Throwable)new Exception())});
        SopCLI.main((String[])new String[]{"generate-key", "Alice"});
    }

    @Test
    @ExpectSystemExitWithStatus(value=1)
    public void ioExceptionCausesExit1() throws SOPGPException.UnsupportedAsymmetricAlgo, SOPGPException.MissingArg, IOException {
        Mockito.when((Object)this.generateKey.generate()).thenReturn((Object)new Ready(){

            public void writeTo(OutputStream outputStream) throws IOException {
                throw new IOException();
            }
        });
        SopCLI.main((String[])new String[]{"generate-key", "Alice"});
    }
}

