/*
 * Decompiled with CFR 0.152.
 */
package sop.cli.picocli.commands;

import com.ginsberg.junit.exit.ExpectSystemExitWithStatus;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import sop.Ready;
import sop.SOP;
import sop.cli.picocli.SopCLI;
import sop.enums.SignAs;
import sop.exception.SOPGPException;
import sop.operation.Sign;

public class SignCmdTest {
    Sign sign;
    File keyFile;

    @BeforeEach
    public void mockComponents() throws IOException, SOPGPException.ExpectedText {
        this.sign = (Sign)Mockito.mock(Sign.class);
        Mockito.when((Object)this.sign.data((InputStream)ArgumentMatchers.any())).thenReturn((Object)new Ready(){

            public void writeTo(OutputStream outputStream) {
            }
        });
        SOP sop = (SOP)Mockito.mock(SOP.class);
        Mockito.when((Object)sop.sign()).thenReturn((Object)this.sign);
        SopCLI.setSopInstance((SOP)sop);
        this.keyFile = File.createTempFile("sign-", ".asc");
    }

    @Test
    public void as_optionsAreCaseInsensitive() {
        SopCLI.main((String[])new String[]{"sign", "--as", "Binary", this.keyFile.getAbsolutePath()});
        SopCLI.main((String[])new String[]{"sign", "--as", "binary", this.keyFile.getAbsolutePath()});
        SopCLI.main((String[])new String[]{"sign", "--as", "BINARY", this.keyFile.getAbsolutePath()});
    }

    @Test
    @ExpectSystemExitWithStatus(value=37)
    public void as_invalidOptionCausesExit37() {
        SopCLI.main((String[])new String[]{"sign", "--as", "Invalid", this.keyFile.getAbsolutePath()});
    }

    @Test
    @ExpectSystemExitWithStatus(value=37)
    public void as_unsupportedOptionCausesExit37() throws SOPGPException.UnsupportedOption {
        Mockito.when((Object)this.sign.mode((SignAs)ArgumentMatchers.any())).thenThrow(new Throwable[]{new SOPGPException.UnsupportedOption("Setting signing mode not supported.")});
        SopCLI.main((String[])new String[]{"sign", "--as", "binary", this.keyFile.getAbsolutePath()});
    }

    @Test
    @ExpectSystemExitWithStatus(value=1)
    public void key_nonExistentKeyFileCausesExit1() {
        SopCLI.main((String[])new String[]{"sign", "invalid.asc"});
    }

    @Test
    @ExpectSystemExitWithStatus(value=1)
    public void key_keyIsProtectedCausesExit1() throws SOPGPException.KeyIsProtected, IOException, SOPGPException.BadData {
        Mockito.when((Object)this.sign.key((InputStream)ArgumentMatchers.any())).thenThrow(new Throwable[]{new SOPGPException.KeyIsProtected()});
        SopCLI.main((String[])new String[]{"sign", this.keyFile.getAbsolutePath()});
    }

    @Test
    @ExpectSystemExitWithStatus(value=41)
    public void key_badDataCausesExit41() throws SOPGPException.KeyIsProtected, IOException, SOPGPException.BadData {
        Mockito.when((Object)this.sign.key((InputStream)ArgumentMatchers.any())).thenThrow(new Throwable[]{new SOPGPException.BadData((Throwable)new IOException())});
        SopCLI.main((String[])new String[]{"sign", this.keyFile.getAbsolutePath()});
    }

    @Test
    @ExpectSystemExitWithStatus(value=19)
    public void key_missingKeyFileCausesExit19() {
        SopCLI.main((String[])new String[]{"sign"});
    }

    @Test
    public void noArmor_notCalledByDefault() {
        SopCLI.main((String[])new String[]{"sign", this.keyFile.getAbsolutePath()});
        ((Sign)Mockito.verify((Object)this.sign, (VerificationMode)Mockito.never())).noArmor();
    }

    @Test
    public void noArmor_passedDown() {
        SopCLI.main((String[])new String[]{"sign", "--no-armor", this.keyFile.getAbsolutePath()});
        ((Sign)Mockito.verify((Object)this.sign, (VerificationMode)Mockito.times((int)1))).noArmor();
    }

    @Test
    @ExpectSystemExitWithStatus(value=1)
    public void data_ioExceptionCausesExit1() throws IOException, SOPGPException.ExpectedText {
        Mockito.when((Object)this.sign.data((InputStream)ArgumentMatchers.any())).thenReturn((Object)new Ready(){

            public void writeTo(OutputStream outputStream) throws IOException {
                throw new IOException();
            }
        });
        SopCLI.main((String[])new String[]{"sign", this.keyFile.getAbsolutePath()});
    }

    @Test
    @ExpectSystemExitWithStatus(value=53)
    public void data_expectedTextExceptionCausesExit53() throws IOException, SOPGPException.ExpectedText {
        Mockito.when((Object)this.sign.data((InputStream)ArgumentMatchers.any())).thenThrow(new Throwable[]{new SOPGPException.ExpectedText()});
        SopCLI.main((String[])new String[]{"sign", this.keyFile.getAbsolutePath()});
    }
}

