/*
 * Decompiled with CFR 0.152.
 */
package sop.cli.picocli.commands;

import com.ginsberg.junit.exit.ExpectSystemExitWithStatus;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import sop.SOP;
import sop.Verification;
import sop.cli.picocli.DateParser;
import sop.cli.picocli.SopCLI;
import sop.exception.SOPGPException;
import sop.operation.Verify;
import sop.util.UTCUtil;

public class VerifyCmdTest {
    Verify verify;
    File signature;
    File cert;
    PrintStream originalSout;

    @BeforeEach
    public void prepare() throws SOPGPException.UnsupportedOption, SOPGPException.BadData, SOPGPException.NoSignature, IOException {
        this.originalSout = System.out;
        this.verify = (Verify)Mockito.mock(Verify.class);
        Mockito.when((Object)this.verify.notBefore((Date)ArgumentMatchers.any())).thenReturn((Object)this.verify);
        Mockito.when((Object)this.verify.notAfter((Date)ArgumentMatchers.any())).thenReturn((Object)this.verify);
        Mockito.when((Object)this.verify.cert((InputStream)ArgumentMatchers.any())).thenReturn((Object)this.verify);
        Mockito.when((Object)this.verify.signatures((InputStream)ArgumentMatchers.any())).thenReturn((Object)this.verify);
        Mockito.when((Object)this.verify.data((InputStream)ArgumentMatchers.any())).thenReturn(Collections.singletonList(new Verification(UTCUtil.parseUTCDate((String)"2019-10-29T18:36:45Z"), "EB85BB5FA33A75E15E944E63F231550C4F47E38E", "EB85BB5FA33A75E15E944E63F231550C4F47E38E")));
        SOP sop = (SOP)Mockito.mock(SOP.class);
        Mockito.when((Object)sop.verify()).thenReturn((Object)this.verify);
        SopCLI.setSopInstance((SOP)sop);
        this.signature = File.createTempFile("signature-", ".asc");
        this.cert = File.createTempFile("cert-", ".asc");
    }

    @AfterEach
    public void restoreSout() {
        System.setOut(this.originalSout);
    }

    @Test
    public void notAfter_passedDown() throws SOPGPException.UnsupportedOption {
        Date date = UTCUtil.parseUTCDate((String)"2019-10-29T18:36:45Z");
        SopCLI.main((String[])new String[]{"verify", "--not-after", "2019-10-29T18:36:45Z", this.signature.getAbsolutePath(), this.cert.getAbsolutePath()});
        ((Verify)Mockito.verify((Object)this.verify, (VerificationMode)Mockito.times((int)1))).notAfter(date);
    }

    @Test
    public void notAfter_now() throws SOPGPException.UnsupportedOption {
        Date now = new Date();
        SopCLI.main((String[])new String[]{"verify", "--not-after", "now", this.signature.getAbsolutePath(), this.cert.getAbsolutePath()});
        ((Verify)Mockito.verify((Object)this.verify, (VerificationMode)Mockito.times((int)1))).notAfter(VerifyCmdTest.dateMatcher(now));
    }

    @Test
    public void notAfter_dashCountsAsEndOfTime() throws SOPGPException.UnsupportedOption {
        SopCLI.main((String[])new String[]{"verify", "--not-after", "-", this.signature.getAbsolutePath(), this.cert.getAbsolutePath()});
        ((Verify)Mockito.verify((Object)this.verify, (VerificationMode)Mockito.times((int)1))).notAfter(DateParser.END_OF_TIME);
    }

    @Test
    @ExpectSystemExitWithStatus(value=37)
    public void notAfter_unsupportedOptionCausesExit37() throws SOPGPException.UnsupportedOption {
        Mockito.when((Object)this.verify.notAfter((Date)ArgumentMatchers.any())).thenThrow(new Throwable[]{new SOPGPException.UnsupportedOption("Setting upper signature date boundary not supported.")});
        SopCLI.main((String[])new String[]{"verify", "--not-after", "2019-10-29T18:36:45Z", this.signature.getAbsolutePath(), this.cert.getAbsolutePath()});
    }

    @Test
    public void notBefore_passedDown() throws SOPGPException.UnsupportedOption {
        Date date = UTCUtil.parseUTCDate((String)"2019-10-29T18:36:45Z");
        SopCLI.main((String[])new String[]{"verify", "--not-before", "2019-10-29T18:36:45Z", this.signature.getAbsolutePath(), this.cert.getAbsolutePath()});
        ((Verify)Mockito.verify((Object)this.verify, (VerificationMode)Mockito.times((int)1))).notBefore(date);
    }

    @Test
    public void notBefore_now() throws SOPGPException.UnsupportedOption {
        Date now = new Date();
        SopCLI.main((String[])new String[]{"verify", "--not-before", "now", this.signature.getAbsolutePath(), this.cert.getAbsolutePath()});
        ((Verify)Mockito.verify((Object)this.verify, (VerificationMode)Mockito.times((int)1))).notBefore(VerifyCmdTest.dateMatcher(now));
    }

    @Test
    public void notBefore_dashCountsAsBeginningOfTime() throws SOPGPException.UnsupportedOption {
        SopCLI.main((String[])new String[]{"verify", "--not-before", "-", this.signature.getAbsolutePath(), this.cert.getAbsolutePath()});
        ((Verify)Mockito.verify((Object)this.verify, (VerificationMode)Mockito.times((int)1))).notBefore(DateParser.BEGINNING_OF_TIME);
    }

    @Test
    @ExpectSystemExitWithStatus(value=37)
    public void notBefore_unsupportedOptionCausesExit37() throws SOPGPException.UnsupportedOption {
        Mockito.when((Object)this.verify.notBefore((Date)ArgumentMatchers.any())).thenThrow(new Throwable[]{new SOPGPException.UnsupportedOption("Setting lower signature date boundary not supported.")});
        SopCLI.main((String[])new String[]{"verify", "--not-before", "2019-10-29T18:36:45Z", this.signature.getAbsolutePath(), this.cert.getAbsolutePath()});
    }

    @Test
    public void notBeforeAndNotAfterAreCalledWithDefaultValues() throws SOPGPException.UnsupportedOption {
        SopCLI.main((String[])new String[]{"verify", this.signature.getAbsolutePath(), this.cert.getAbsolutePath()});
        ((Verify)Mockito.verify((Object)this.verify, (VerificationMode)Mockito.times((int)1))).notAfter(VerifyCmdTest.dateMatcher(new Date()));
        ((Verify)Mockito.verify((Object)this.verify, (VerificationMode)Mockito.times((int)1))).notBefore(DateParser.BEGINNING_OF_TIME);
    }

    private static Date dateMatcher(Date date) {
        return (Date)ArgumentMatchers.argThat(argument -> Math.abs(argument.getTime() - date.getTime()) < 1000L);
    }

    @Test
    @ExpectSystemExitWithStatus(value=1)
    public void cert_fileNotFoundCausesExit1() {
        SopCLI.main((String[])new String[]{"verify", this.signature.getAbsolutePath(), "invalid.asc"});
    }

    @Test
    @ExpectSystemExitWithStatus(value=41)
    public void cert_badDataCausesExit41() throws SOPGPException.BadData {
        Mockito.when((Object)this.verify.cert((InputStream)ArgumentMatchers.any())).thenThrow(new Throwable[]{new SOPGPException.BadData((Throwable)new IOException())});
        SopCLI.main((String[])new String[]{"verify", this.signature.getAbsolutePath(), this.cert.getAbsolutePath()});
    }

    @Test
    @ExpectSystemExitWithStatus(value=1)
    public void signature_fileNotFoundCausesExit1() {
        SopCLI.main((String[])new String[]{"verify", "invalid.sig", this.cert.getAbsolutePath()});
    }

    @Test
    @ExpectSystemExitWithStatus(value=41)
    public void signature_badDataCausesExit41() throws SOPGPException.BadData {
        Mockito.when((Object)this.verify.signatures((InputStream)ArgumentMatchers.any())).thenThrow(new Throwable[]{new SOPGPException.BadData((Throwable)new IOException())});
        SopCLI.main((String[])new String[]{"verify", this.signature.getAbsolutePath(), this.cert.getAbsolutePath()});
    }

    @Test
    @ExpectSystemExitWithStatus(value=3)
    public void data_noSignaturesCausesExit3() throws SOPGPException.NoSignature, IOException, SOPGPException.BadData {
        Mockito.when((Object)this.verify.data((InputStream)ArgumentMatchers.any())).thenThrow(new Throwable[]{new SOPGPException.NoSignature()});
        SopCLI.main((String[])new String[]{"verify", this.signature.getAbsolutePath(), this.cert.getAbsolutePath()});
    }

    @Test
    @ExpectSystemExitWithStatus(value=41)
    public void data_badDataCausesExit41() throws SOPGPException.NoSignature, IOException, SOPGPException.BadData {
        Mockito.when((Object)this.verify.data((InputStream)ArgumentMatchers.any())).thenThrow(new Throwable[]{new SOPGPException.BadData((Throwable)new IOException())});
        SopCLI.main((String[])new String[]{"verify", this.signature.getAbsolutePath(), this.cert.getAbsolutePath()});
    }

    @Test
    public void resultIsPrintedProperly() throws SOPGPException.NoSignature, IOException, SOPGPException.BadData {
        Mockito.when((Object)this.verify.data((InputStream)ArgumentMatchers.any())).thenReturn(Arrays.asList(new Verification(UTCUtil.parseUTCDate((String)"2019-10-29T18:36:45Z"), "EB85BB5FA33A75E15E944E63F231550C4F47E38E", "EB85BB5FA33A75E15E944E63F231550C4F47E38E"), new Verification(UTCUtil.parseUTCDate((String)"2019-10-24T23:48:29Z"), "C90E6D36200A1B922A1509E77618196529AE5FF8", "C4BC2DDB38CCE96485EBE9C2F20691179038E5C6")));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        System.setOut(new PrintStream(out));
        SopCLI.main((String[])new String[]{"verify", this.signature.getAbsolutePath(), this.cert.getAbsolutePath()});
        System.setOut(this.originalSout);
        String expected = "2019-10-29T18:36:45Z EB85BB5FA33A75E15E944E63F231550C4F47E38E EB85BB5FA33A75E15E944E63F231550C4F47E38E\n2019-10-24T23:48:29Z C90E6D36200A1B922A1509E77618196529AE5FF8 C4BC2DDB38CCE96485EBE9C2F20691179038E5C6\n";
        Assertions.assertEquals((Object)expected, (Object)out.toString());
    }
}

