/*
 * Decompiled with CFR 0.152.
 */
package sop.cli.picocli.commands;

import com.ginsberg.junit.exit.ExpectSystemExitWithStatus;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import sop.SOP;
import sop.cli.picocli.SopCLI;
import sop.operation.Version;

public class VersionCmdTest {
    private SOP sop;
    private Version version;

    @BeforeEach
    public void mockComponents() {
        this.sop = (SOP)Mockito.mock(SOP.class);
        this.version = (Version)Mockito.mock(Version.class);
        Mockito.when((Object)this.version.getName()).thenReturn((Object)"MockSop");
        Mockito.when((Object)this.version.getVersion()).thenReturn((Object)"1.0");
        Mockito.when((Object)this.sop.version()).thenReturn((Object)this.version);
        SopCLI.setSopInstance((SOP)this.sop);
    }

    @Test
    public void assertVersionCommandWorks() {
        SopCLI.main((String[])new String[]{"version"});
        ((Version)Mockito.verify((Object)this.version, (VerificationMode)Mockito.times((int)1))).getVersion();
        ((Version)Mockito.verify((Object)this.version, (VerificationMode)Mockito.times((int)1))).getName();
    }

    @Test
    @ExpectSystemExitWithStatus(value=37)
    public void assertInvalidOptionResultsInExit37() {
        SopCLI.main((String[])new String[]{"version", "--invalid"});
    }
}

