/*
 * Decompiled with CFR 0.152.
 */
package sop;

import java.util.Arrays;
import sop.util.HexUtil;

public class SessionKey {
    private final byte algorithm;
    private final byte[] sessionKey;

    public SessionKey(byte algorithm, byte[] sessionKey) {
        this.algorithm = algorithm;
        this.sessionKey = sessionKey;
    }

    public byte getAlgorithm() {
        return this.algorithm;
    }

    public byte[] getKey() {
        return this.sessionKey;
    }

    public int hashCode() {
        return this.getAlgorithm() * 17 + Arrays.hashCode(this.getKey());
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof SessionKey)) {
            return false;
        }
        SessionKey otherKey = (SessionKey)other;
        return this.getAlgorithm() == otherKey.getAlgorithm() && Arrays.equals(this.getKey(), otherKey.getKey());
    }

    public String toString() {
        return "" + this.getAlgorithm() + ':' + HexUtil.bytesToHex(this.sessionKey);
    }
}

