/*
 * Decompiled with CFR 0.152.
 */
package sop.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ProxyOutputStream
extends OutputStream {
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private OutputStream swapped;

    public synchronized void replaceOutputStream(OutputStream underlying) throws IOException {
        if (underlying == null) {
            throw new NullPointerException("Underlying OutputStream cannot be null.");
        }
        this.swapped = underlying;
        byte[] bufferBytes = this.buffer.toByteArray();
        this.swapped.write(bufferBytes);
    }

    @Override
    public synchronized void write(byte[] b) throws IOException {
        if (this.swapped == null) {
            this.buffer.write(b);
        } else {
            this.swapped.write(b);
        }
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (this.swapped == null) {
            this.buffer.write(b, off, len);
        } else {
            this.swapped.write(b, off, len);
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        this.buffer.flush();
        if (this.swapped != null) {
            this.swapped.flush();
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.buffer.close();
        if (this.swapped != null) {
            this.swapped.close();
        }
    }

    @Override
    public synchronized void write(int i) throws IOException {
        if (this.swapped == null) {
            this.buffer.write(i);
        } else {
            this.swapped.write(i);
        }
    }
}

