/*
 * Decompiled with CFR 0.152.
 */
package sop.cli.picocli.commands;

import java.io.IOException;
import picocli.CommandLine;
import sop.Ready;
import sop.cli.picocli.Print;
import sop.cli.picocli.SopCLI;
import sop.enums.ArmorLabel;
import sop.exception.SOPGPException;
import sop.operation.Armor;

@CommandLine.Command(name="armor", description={"Add ASCII Armor to standard input"}, exitCodeOnInvalidInput=37)
public class ArmorCmd
implements Runnable {
    @CommandLine.Option(names={"--label"}, description={"Label to be used in the header and tail of the armoring."}, paramLabel="{auto|sig|key|cert|message}")
    ArmorLabel label;

    @Override
    public void run() {
        Armor armor = SopCLI.getSop().armor();
        if (this.label != null) {
            try {
                armor.label(this.label);
            }
            catch (SOPGPException.UnsupportedOption unsupportedOption) {
                Print.errln("Armor labels not supported.");
                System.exit(unsupportedOption.getExitCode());
            }
        }
        try {
            Ready ready = armor.data(System.in);
            ready.writeTo(System.out);
        }
        catch (SOPGPException.BadData badData) {
            Print.errln("Bad data.");
            Print.trace(badData);
            System.exit(badData.getExitCode());
        }
        catch (IOException e) {
            Print.errln("IO Error.");
            Print.trace(e);
            System.exit(1);
        }
    }
}

