/*
 * Decompiled with CFR 0.152.
 */
package sop;

import java.util.Date;
import sop.util.UTCUtil;

public class Verification {
    private final Date creationTime;
    private final String signingKeyFingerprint;
    private final String signingCertFingerprint;

    public Verification(Date creationTime, String signingKeyFingerprint, String signingCertFingerprint) {
        this.creationTime = creationTime;
        this.signingKeyFingerprint = signingKeyFingerprint;
        this.signingCertFingerprint = signingCertFingerprint;
    }

    public static Verification fromString(String toString) {
        String[] split = toString.trim().split(" ");
        if (split.length != 3) {
            throw new IllegalArgumentException("Verification must be of the format 'UTC-DATE OpenPGPFingerprint OpenPGPFingerprint'");
        }
        return new Verification(UTCUtil.parseUTCDate(split[0]), split[1], split[2]);
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public String getSigningKeyFingerprint() {
        return this.signingKeyFingerprint;
    }

    public String getSigningCertFingerprint() {
        return this.signingCertFingerprint;
    }

    public String toString() {
        return UTCUtil.formatUTCDate(this.getCreationTime()) + ' ' + this.getSigningKeyFingerprint() + ' ' + this.getSigningCertFingerprint();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Verification)) {
            return false;
        }
        Verification other = (Verification)obj;
        return this.toString().equals(other.toString());
    }
}

