/*
 * Decompiled with CFR 0.152.
 */
package sop.operation;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import sop.Ready;
import sop.enums.EncryptAs;
import sop.exception.SOPGPException;

public interface Encrypt {
    public Encrypt noArmor();

    public Encrypt mode(EncryptAs var1) throws SOPGPException.UnsupportedOption;

    public Encrypt signWith(InputStream var1) throws SOPGPException.KeyCannotSign, SOPGPException.UnsupportedAsymmetricAlgo, SOPGPException.BadData, IOException;

    default public Encrypt signWith(byte[] key) throws SOPGPException.KeyCannotSign, SOPGPException.UnsupportedAsymmetricAlgo, SOPGPException.BadData, IOException {
        return this.signWith(new ByteArrayInputStream(key));
    }

    default public Encrypt withKeyPassword(String password) throws SOPGPException.PasswordNotHumanReadable, SOPGPException.UnsupportedOption {
        return this.withKeyPassword(password.getBytes(Charset.forName("UTF8")));
    }

    public Encrypt withKeyPassword(byte[] var1) throws SOPGPException.PasswordNotHumanReadable, SOPGPException.UnsupportedOption;

    public Encrypt withPassword(String var1) throws SOPGPException.PasswordNotHumanReadable, SOPGPException.UnsupportedOption;

    public Encrypt withCert(InputStream var1) throws SOPGPException.CertCannotEncrypt, SOPGPException.UnsupportedAsymmetricAlgo, SOPGPException.BadData, IOException;

    default public Encrypt withCert(byte[] cert) throws SOPGPException.CertCannotEncrypt, SOPGPException.UnsupportedAsymmetricAlgo, SOPGPException.BadData, IOException {
        return this.withCert(new ByteArrayInputStream(cert));
    }

    public Ready plaintext(InputStream var1) throws IOException, SOPGPException.KeyIsProtected;

    default public Ready plaintext(byte[] plaintext) throws IOException, SOPGPException.KeyIsProtected {
        return this.plaintext(new ByteArrayInputStream(plaintext));
    }
}

