/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.activities;

import edu.umd.cs.piccolo.activities.PInterpolatingActivity;
import edu.umd.cs.piccolo.util.PAffineTransform;
import java.awt.geom.AffineTransform;

public class PTransformActivity
extends PInterpolatingActivity {
    private static final PAffineTransform STATIC_TRANSFORM = new PAffineTransform();
    private final double[] source = new double[6];
    private double[] destination = new double[6];
    private final Target target;

    public PTransformActivity(long duration, long stepRate, Target target) {
        this(duration, stepRate, target, null);
    }

    public PTransformActivity(long duration, long stepRate, Target target, AffineTransform destination) {
        this(duration, stepRate, 1, 1, target, destination);
    }

    public PTransformActivity(long duration, long stepRate, int loopCount, int mode, Target target, AffineTransform destination) {
        super(duration, stepRate, loopCount, mode);
        this.target = target;
        if (destination != null) {
            destination.getMatrix(this.destination);
        }
    }

    protected boolean isAnimation() {
        return true;
    }

    public double[] getDestinationTransform() {
        if (this.destination == null) {
            return null;
        }
        return (double[])this.destination.clone();
    }

    public void setDestinationTransform(double[] newDestination) {
        this.destination = (double[])(newDestination == null ? null : (double[])newDestination.clone());
    }

    protected void activityStarted() {
        if (this.getFirstLoop()) {
            this.target.getSourceMatrix(this.source);
        }
        super.activityStarted();
    }

    public void setRelativeTargetValue(float zeroToOne) {
        super.setRelativeTargetValue(zeroToOne);
        if (this.destination == null) {
            return;
        }
        STATIC_TRANSFORM.setTransform(this.source[0] + (double)zeroToOne * (this.destination[0] - this.source[0]), this.source[1] + (double)zeroToOne * (this.destination[1] - this.source[1]), this.source[2] + (double)zeroToOne * (this.destination[2] - this.source[2]), this.source[3] + (double)zeroToOne * (this.destination[3] - this.source[3]), this.source[4] + (double)zeroToOne * (this.destination[4] - this.source[4]), this.source[5] + (double)zeroToOne * (this.destination[5] - this.source[5]));
        this.target.setTransform(STATIC_TRANSFORM);
    }

    public static interface Target {
        public void setTransform(AffineTransform var1);

        public void getSourceMatrix(double[] var1);
    }
}

