/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.tck;

import java.util.Properties;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.picocontainer.Characteristics;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentFactory;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.DefaultPicoContainer;
import org.picocontainer.LifecycleStrategy;
import org.picocontainer.Parameter;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.lifecycle.NullLifecycleStrategy;
import org.picocontainer.monitors.NullComponentMonitor;
import org.picocontainer.testmodel.SimpleTouchable;
import org.picocontainer.testmodel.Touchable;

public abstract class AbstractComponentFactoryTest {
    protected DefaultPicoContainer picoContainer;

    protected abstract ComponentFactory createComponentFactory();

    @Before
    public void setUp() throws Exception {
        this.picoContainer = new DefaultPicoContainer();
    }

    @Test
    public void testEquals() throws PicoCompositionException {
        ComponentAdapter componentAdapter = this.createComponentFactory().createComponentAdapter((ComponentMonitor)new NullComponentMonitor(), (LifecycleStrategy)new NullLifecycleStrategy(), new Properties(Characteristics.CDI), Touchable.class, SimpleTouchable.class, new Parameter[0]);
        Assert.assertEquals((Object)componentAdapter, (Object)componentAdapter);
        Assert.assertTrue((!componentAdapter.equals("blah") ? 1 : 0) != 0);
    }

    @Test
    public void testRegisterComponent() throws PicoCompositionException {
        ComponentAdapter componentAdapter = this.createComponentFactory().createComponentAdapter((ComponentMonitor)new NullComponentMonitor(), (LifecycleStrategy)new NullLifecycleStrategy(), new Properties(Characteristics.CDI), Touchable.class, SimpleTouchable.class, new Parameter[0]);
        this.picoContainer.addAdapter(componentAdapter);
        ComponentAdapter adapter = (ComponentAdapter)this.picoContainer.getComponentAdapters().toArray()[0];
        Assert.assertSame((Object)componentAdapter.getComponentKey(), (Object)adapter.getComponentKey());
    }

    @Test
    public void testUnregisterComponent() throws PicoCompositionException {
        ComponentAdapter componentAdapter = this.createComponentFactory().createComponentAdapter((ComponentMonitor)new NullComponentMonitor(), (LifecycleStrategy)new NullLifecycleStrategy(), new Properties(Characteristics.CDI), Touchable.class, SimpleTouchable.class, new Parameter[0]);
        this.picoContainer.addAdapter(componentAdapter);
        this.picoContainer.removeComponent(Touchable.class);
        Assert.assertFalse((boolean)this.picoContainer.getComponentAdapters().contains(componentAdapter));
    }
}

