/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.gems.adapters;

import java.util.Properties;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.LifecycleStrategy;
import org.picocontainer.Parameter;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.gems.adapters.DelegateMethodAdapter;
import org.picocontainer.gems.util.DelegateMethod;
import org.picocontainer.injectors.AbstractInjectionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegateAdaptorFactory
extends AbstractInjectionFactory {
    private static final String DELEGATE = "delegateInstance";
    private static final String INSTANCE = "targetInstance";

    public <T> ComponentAdapter<T> createComponentAdapter(ComponentMonitor componentMonitor, LifecycleStrategy lifecycleStrategy, Properties componentProperties, Object componentKey, Class<T> componentImplementation, Parameter ... parameters) throws PicoCompositionException {
        DelegateMethod method = (DelegateMethod)this.cast(componentProperties.remove(DELEGATE));
        if (method == null) {
            throw new IllegalArgumentException("Component properties must have a org.picocontainer.gems.util.DelegateMethod object stored as delegateInstance");
        }
        Object instance = componentProperties.remove(INSTANCE);
        if (instance == null) {
            throw new IllegalArgumentException("Property 'instance' must exist.");
        }
        return new DelegateMethodAdapter(componentKey, componentMonitor, instance, method);
    }

    private <T> T cast(Object source) {
        return (T)source;
    }

    public static Properties createDelegateProprties(Object targetObject, String methodName, Object ... parameters) {
        Properties props = new Properties();
        props.put(INSTANCE, targetObject);
        props.put(DELEGATE, DelegateAdaptorFactory.createDelegate(targetObject.getClass(), methodName, parameters));
        return props;
    }

    public static <INSTANCE, RETURN_TYPE> DelegateMethod<INSTANCE, RETURN_TYPE> createDelegate(Class<INSTANCE> targetType, String methodName, Object ... parameters) {
        return new DelegateMethod(targetType, methodName, parameters);
    }
}

