/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.gems.adapters;

import java.lang.reflect.Type;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoVisitor;
import org.picocontainer.gems.util.DelegateMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegateMethodAdapter<T>
implements ComponentAdapter<T> {
    private final DelegateMethod factoryMethod;
    private final Object targetInstance;
    private final Object key;

    public DelegateMethodAdapter(Object componentKey, Object targetInstance, DelegateMethod factoryMethod) {
        this.factoryMethod = factoryMethod;
        this.targetInstance = targetInstance;
        this.key = componentKey;
    }

    public DelegateMethodAdapter(Object componentKey, ComponentMonitor monitor, Object targetInstance, DelegateMethod factoryMethod) {
        this.factoryMethod = factoryMethod;
        this.targetInstance = targetInstance;
        this.key = componentKey;
    }

    public T getComponentInstance(PicoContainer container, Type into) throws PicoCompositionException {
        try {
            return (T)this.factoryMethod.invoke(this.targetInstance);
        }
        catch (RuntimeException e) {
            throw new PicoCompositionException("Error invoking delegate for object construction", (Throwable)e);
        }
    }

    public String getDescriptor() {
        return "Delegate Adapter.  Delegate: " + this.factoryMethod.toString();
    }

    public void verify(PicoContainer container) throws PicoCompositionException {
    }

    public void accept(PicoVisitor visitor) {
        visitor.visitComponentAdapter((ComponentAdapter)this);
    }

    public ComponentAdapter<T> findAdapterOfType(Class adapterType) {
        if (adapterType == null) {
            return null;
        }
        if (DelegateMethodAdapter.class.isAssignableFrom(adapterType)) {
            return this;
        }
        return null;
    }

    public Class<T> getComponentImplementation() {
        return this.factoryMethod.getReturnType();
    }

    @Deprecated
    public T getComponentInstance(PicoContainer container) throws PicoCompositionException {
        return this.getComponentInstance(container, null);
    }

    public Object getComponentKey() {
        return this.key;
    }

    public ComponentAdapter<T> getDelegate() {
        return null;
    }
}

