/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.picocontainer.BehaviorFactory;
import org.picocontainer.BindKey;
import org.picocontainer.Characteristics;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentFactory;
import org.picocontainer.ComponentLifecycle;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.ComponentMonitorStrategy;
import org.picocontainer.Disposable;
import org.picocontainer.LifecycleStrategy;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.NameBinding;
import org.picocontainer.Parameter;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoException;
import org.picocontainer.PicoVisitor;
import org.picocontainer.Startable;
import org.picocontainer.adapters.AbstractAdapter;
import org.picocontainer.adapters.InstanceAdapter;
import org.picocontainer.behaviors.AbstractBehaviorFactory;
import org.picocontainer.behaviors.AdaptingBehavior;
import org.picocontainer.containers.AbstractDelegatingMutablePicoContainer;
import org.picocontainer.containers.AbstractDelegatingPicoContainer;
import org.picocontainer.containers.EmptyPicoContainer;
import org.picocontainer.containers.ImmutablePicoContainer;
import org.picocontainer.injectors.AbstractInjector;
import org.picocontainer.injectors.FactoryInjector;
import org.picocontainer.lifecycle.DefaultLifecycleState;
import org.picocontainer.lifecycle.LifecycleState;
import org.picocontainer.lifecycle.StartableLifecycleStrategy;
import org.picocontainer.monitors.NullComponentMonitor;
import org.picocontainer.parameters.DefaultConstructorParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPicoContainer
implements MutablePicoContainer,
ComponentMonitorStrategy,
Serializable {
    private String name;
    protected final ComponentFactory componentFactory;
    private PicoContainer parent;
    private final Set<PicoContainer> children = new HashSet<PicoContainer>();
    private LifecycleState lifecycleState = new DefaultLifecycleState();
    private final Set<WeakReference<PicoContainer>> childrenStarted = new HashSet<WeakReference<PicoContainer>>();
    protected final LifecycleStrategy lifecycleStrategy;
    private final Properties containerProperties = new Properties();
    protected ComponentMonitor componentMonitor;
    private final Map<Object, ComponentAdapter<?>> componentKeyToAdapterCache = new HashMap();
    private final List<ComponentAdapter<?>> componentAdapters = new ArrayList();
    protected final List<ComponentAdapter<?>> orderedComponentAdapters = new ArrayList();
    private transient IntoThreadLocal intoThreadLocal = new IntoThreadLocal();

    public DefaultPicoContainer(ComponentFactory componentFactory, PicoContainer parent) {
        this(componentFactory, new StartableLifecycleStrategy(new NullComponentMonitor()), parent, new NullComponentMonitor());
    }

    public DefaultPicoContainer(ComponentFactory componentFactory, LifecycleStrategy lifecycleStrategy, PicoContainer parent) {
        this(componentFactory, lifecycleStrategy, parent, new NullComponentMonitor());
    }

    public DefaultPicoContainer(ComponentFactory componentFactory, LifecycleStrategy lifecycleStrategy, PicoContainer parent, ComponentMonitor componentMonitor) {
        if (componentFactory == null) {
            throw new NullPointerException("componentFactory");
        }
        if (lifecycleStrategy == null) {
            throw new NullPointerException("lifecycleStrategy");
        }
        this.componentFactory = componentFactory;
        this.lifecycleStrategy = lifecycleStrategy;
        this.parent = parent;
        if (parent != null && !(parent instanceof EmptyPicoContainer)) {
            this.parent = new ImmutablePicoContainer(parent);
        }
        this.componentMonitor = componentMonitor;
    }

    public DefaultPicoContainer(ComponentMonitor monitor, PicoContainer parent) {
        this(new AdaptingBehavior(), new StartableLifecycleStrategy(monitor), parent, monitor);
    }

    public DefaultPicoContainer(ComponentMonitor monitor, LifecycleStrategy lifecycleStrategy, PicoContainer parent) {
        this(new AdaptingBehavior(), lifecycleStrategy, parent, monitor);
    }

    public DefaultPicoContainer(LifecycleStrategy lifecycleStrategy, PicoContainer parent) {
        this(new NullComponentMonitor(), lifecycleStrategy, parent);
    }

    public DefaultPicoContainer(ComponentFactory componentFactory) {
        this(componentFactory, null);
    }

    public DefaultPicoContainer(ComponentMonitor monitor) {
        this(monitor, (LifecycleStrategy)new StartableLifecycleStrategy(monitor), null);
    }

    public DefaultPicoContainer(PicoContainer parent) {
        this(new AdaptingBehavior(), parent);
    }

    public DefaultPicoContainer() {
        this(new AdaptingBehavior(), null);
    }

    @Override
    public Collection<ComponentAdapter<?>> getComponentAdapters() {
        return Collections.unmodifiableList(this.getModifiableComponentAdapterList());
    }

    @Override
    public final ComponentAdapter<?> getComponentAdapter(Object componentKey) {
        Object inst;
        LateInstance adapter = this.getComponentKeyToAdapterCache().get(componentKey);
        if (adapter == null && this.parent != null) {
            adapter = this.getParent().getComponentAdapter(componentKey);
        }
        if (adapter == null && (inst = this.componentMonitor.noComponentFound(this, componentKey)) != null) {
            adapter = new LateInstance(componentKey, inst);
        }
        return adapter;
    }

    @Override
    public <T> ComponentAdapter<T> getComponentAdapter(Class<T> componentType, NameBinding componentNameBinding) {
        return this.getComponentAdapter(componentType, componentNameBinding, null);
    }

    private <T> ComponentAdapter<T> getComponentAdapter(Class<T> componentType, NameBinding componentNameBinding, Class<? extends Annotation> binding) {
        ComponentAdapter<?> ca;
        String parameterName;
        List<ComponentAdapter<T>> found;
        ComponentAdapter<?> adapterByKey = this.getComponentAdapter(componentType);
        if (adapterByKey != null) {
            return DefaultPicoContainer.typeComponentAdapter(adapterByKey);
        }
        List<ComponentAdapter<T>> list = found = binding == null ? this.getComponentAdapters(componentType) : this.getComponentAdapters(componentType, binding);
        if (found.size() == 1) {
            return found.get(0);
        }
        if (found.isEmpty()) {
            if (this.parent != null) {
                return this.getParent().getComponentAdapter(componentType, componentNameBinding);
            }
            return null;
        }
        if (componentNameBinding != null && (parameterName = componentNameBinding.getName()) != null && (ca = this.getComponentAdapter(parameterName)) != null && componentType.isAssignableFrom(ca.getComponentImplementation())) {
            return DefaultPicoContainer.typeComponentAdapter(ca);
        }
        Object[] foundClasses = new Class[found.size()];
        for (int i = 0; i < foundClasses.length; ++i) {
            foundClasses[i] = found.get(i).getComponentImplementation();
        }
        throw new AbstractInjector.AmbiguousComponentResolutionException(componentType, foundClasses);
    }

    @Override
    public <T> ComponentAdapter<T> getComponentAdapter(Class<T> componentType, Class<? extends Annotation> binding) {
        return this.getComponentAdapter(componentType, null, binding);
    }

    @Override
    public <T> List<ComponentAdapter<T>> getComponentAdapters(Class<T> componentType) {
        return this.getComponentAdapters(componentType, null);
    }

    @Override
    public <T> List<ComponentAdapter<T>> getComponentAdapters(Class<T> componentType, Class<? extends Annotation> binding) {
        if (componentType == null) {
            return Collections.emptyList();
        }
        ArrayList<ComponentAdapter<T>> found = new ArrayList<ComponentAdapter<T>>();
        for (ComponentAdapter<?> componentAdapter : this.getComponentAdapters()) {
            Object k = componentAdapter.getComponentKey();
            if (!componentType.isAssignableFrom(componentAdapter.getComponentImplementation()) || k instanceof BindKey && (!(k instanceof BindKey) || ((BindKey)k).getAnnotation() != null && binding != null && ((BindKey)k).getAnnotation() != binding)) continue;
            found.add(DefaultPicoContainer.typeComponentAdapter(componentAdapter));
        }
        return found;
    }

    protected MutablePicoContainer addAdapterInternal(ComponentAdapter<?> componentAdapter) {
        Object componentKey = componentAdapter.getComponentKey();
        if (this.getComponentKeyToAdapterCache().containsKey(componentKey)) {
            throw new PicoCompositionException("Duplicate Keys not allowed. Duplicate for '" + componentKey + "'");
        }
        this.getModifiableComponentAdapterList().add(componentAdapter);
        this.getComponentKeyToAdapterCache().put(componentKey, componentAdapter);
        return this;
    }

    @Override
    public MutablePicoContainer addAdapter(ComponentAdapter<?> componentAdapter) {
        return this.addAdapter(componentAdapter, this.containerProperties);
    }

    public MutablePicoContainer addAdapter(ComponentAdapter<?> componentAdapter, Properties properties) {
        Properties tmpProperties = (Properties)properties.clone();
        if (!AbstractBehaviorFactory.removePropertiesIfPresent(tmpProperties, Characteristics.NONE) && this.componentFactory instanceof BehaviorFactory) {
            MutablePicoContainer container = this.addAdapterInternal(((BehaviorFactory)this.componentFactory).addComponentAdapter(this.componentMonitor, this.lifecycleStrategy, tmpProperties, componentAdapter));
            this.throwIfPropertiesLeft(tmpProperties);
            return container;
        }
        return this.addAdapterInternal(componentAdapter);
    }

    @Override
    public <T> ComponentAdapter<T> removeComponent(Object componentKey) {
        this.lifecycleState.removingComponent();
        ComponentAdapter<?> adapter = this.getComponentKeyToAdapterCache().remove(componentKey);
        this.getModifiableComponentAdapterList().remove(adapter);
        this.getOrderedComponentAdapters().remove(adapter);
        return adapter;
    }

    @Override
    public MutablePicoContainer addComponent(Object implOrInstance) {
        return this.addComponent(implOrInstance, this.containerProperties);
    }

    private MutablePicoContainer addComponent(Object implOrInstance, Properties props) {
        if (implOrInstance instanceof String) {
            return this.addComponent(implOrInstance, implOrInstance, new Parameter[0]);
        }
        Class<?> clazz = implOrInstance instanceof Class ? (Class<?>)implOrInstance : implOrInstance.getClass();
        return this.addComponent(clazz, implOrInstance, props, new Parameter[0]);
    }

    @Override
    public MutablePicoContainer addConfig(String name, Object val) {
        return this.addAdapterInternal(new InstanceAdapter<Object>(name, val, this.lifecycleStrategy, this.componentMonitor));
    }

    @Override
    public MutablePicoContainer addComponent(Object componentKey, Object componentImplementationOrInstance, Parameter ... parameters) {
        return this.addComponent(componentKey, componentImplementationOrInstance, this.containerProperties, parameters);
    }

    private MutablePicoContainer addComponent(Object componentKey, Object componentImplementationOrInstance, Properties properties, Parameter ... parameters) {
        if (parameters != null && parameters.length == 0) {
            parameters = null;
        }
        if (parameters != null && parameters.length == 1 && DefaultConstructorParameter.INSTANCE.equals(parameters[0])) {
            parameters = new Parameter[]{};
        }
        if (componentImplementationOrInstance instanceof Class) {
            Properties tmpProperties = (Properties)properties.clone();
            ComponentAdapter componentAdapter = this.componentFactory.createComponentAdapter(this.componentMonitor, this.lifecycleStrategy, tmpProperties, componentKey, (Class)componentImplementationOrInstance, parameters);
            AbstractBehaviorFactory.removePropertiesIfPresent(tmpProperties, Characteristics.USE_NAMES);
            this.throwIfPropertiesLeft(tmpProperties);
            return this.addAdapterInternal(componentAdapter);
        }
        InstanceAdapter<Object> componentAdapter = new InstanceAdapter<Object>(componentKey, componentImplementationOrInstance, this.lifecycleStrategy, this.componentMonitor);
        return this.addAdapter(componentAdapter, properties);
    }

    private void throwIfPropertiesLeft(Properties tmpProperties) {
        if (tmpProperties.size() > 0) {
            throw new PicoCompositionException("Unprocessed Characteristics:" + tmpProperties + ", please refer to http://picocontainer.org/unprocessed-properties-help.html");
        }
    }

    private void addOrderedComponentAdapter(ComponentAdapter<?> componentAdapter) {
        if (!this.getOrderedComponentAdapters().contains(componentAdapter)) {
            this.getOrderedComponentAdapters().add(componentAdapter);
        }
    }

    @Override
    public List<Object> getComponents() throws PicoException {
        return this.getComponents(Object.class);
    }

    @Override
    public <T> List<T> getComponents(Class<T> componentType) {
        Object componentInstance;
        if (componentType == null) {
            return Collections.emptyList();
        }
        HashMap<ComponentAdapter<T>, T> adapterToInstanceMap = new HashMap<ComponentAdapter<T>, T>();
        for (ComponentAdapter<?> componentAdapter : this.getModifiableComponentAdapterList()) {
            if (!componentType.isAssignableFrom(componentAdapter.getComponentImplementation())) continue;
            ComponentAdapter<T> typedComponentAdapter = DefaultPicoContainer.typeComponentAdapter(componentAdapter);
            componentInstance = this.getLocalInstance(typedComponentAdapter);
            adapterToInstanceMap.put(typedComponentAdapter, componentInstance);
        }
        ArrayList<T> result = new ArrayList<T>();
        for (ComponentAdapter<?> componentAdapter : this.getOrderedComponentAdapters()) {
            componentInstance = adapterToInstanceMap.get(componentAdapter);
            if (componentInstance == null) continue;
            result.add(componentInstance);
        }
        return result;
    }

    private <T> T getLocalInstance(ComponentAdapter<T> typedComponentAdapter) {
        T componentInstance = typedComponentAdapter.getComponentInstance(this, (Type)((Object)ComponentAdapter.NOTHING.class));
        this.addOrderedComponentAdapter(typedComponentAdapter);
        return componentInstance;
    }

    private static <T> ComponentAdapter<T> typeComponentAdapter(ComponentAdapter<?> componentAdapter) {
        return componentAdapter;
    }

    @Override
    public Object getComponent(Object componentKeyOrType) {
        return this.getComponent(componentKeyOrType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getComponent(Object componentKeyOrType, Type into) {
        DefaultPicoContainer defaultPicoContainer = this;
        synchronized (defaultPicoContainer) {
            if (this.intoThreadLocal == null) {
                this.intoThreadLocal = new IntoThreadLocal();
            }
        }
        this.intoThreadLocal.set(into);
        return this.getComponent(componentKeyOrType, (Class<? extends Annotation>)null);
    }

    public Object getComponent(Object componentKeyOrType, Class<? extends Annotation> annotation) {
        if (annotation != null) {
            ComponentAdapter componentAdapter = this.getComponentAdapter((Class)componentKeyOrType, annotation);
            return componentAdapter == null ? null : this.getInstance(componentAdapter, null);
        }
        if (componentKeyOrType instanceof Class) {
            ComponentAdapter componentAdapter = this.getComponentAdapter((Class)componentKeyOrType, (NameBinding)null);
            return componentAdapter == null ? null : this.getInstance(componentAdapter, (Class)componentKeyOrType);
        }
        ComponentAdapter<?> componentAdapter = this.getComponentAdapter(componentKeyOrType);
        return componentAdapter == null ? null : this.getInstance(componentAdapter, null);
    }

    @Override
    public <T> T getComponent(Class<T> componentType) {
        Object o = this.getComponent((Object)componentType, null);
        return componentType.cast(o);
    }

    @Override
    public <T> T getComponent(Class<T> componentType, Class<? extends Annotation> binding) {
        Object o = this.getComponent((Object)componentType, binding);
        return componentType.cast(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getInstance(ComponentAdapter<?> componentAdapter, Class componentKey) {
        boolean isLocal = this.getModifiableComponentAdapterList().contains(componentAdapter);
        if (isLocal) {
            Object instance;
            block10: {
                try {
                    if (componentAdapter instanceof FactoryInjector) {
                        instance = ((FactoryInjector)componentAdapter).getComponentInstance(this, (Type)this.intoThreadLocal.get());
                        break block10;
                    }
                    DefaultPicoContainer defaultPicoContainer = this;
                    synchronized (defaultPicoContainer) {
                        if (this.intoThreadLocal == null) {
                            this.intoThreadLocal = new IntoThreadLocal();
                        }
                    }
                    this.intoThreadLocal.set(componentAdapter.getComponentImplementation());
                    instance = componentAdapter.getComponentInstance(this, (Type)((Object)ComponentAdapter.NOTHING.class));
                }
                catch (AbstractInjector.CyclicDependencyException e) {
                    Object instance2;
                    if (this.parent != null && (instance2 = this.getParent().getComponent(componentAdapter.getComponentKey())) != null) {
                        return instance2;
                    }
                    throw e;
                }
            }
            this.addOrderedComponentAdapter(componentAdapter);
            return instance;
        }
        if (this.parent != null) {
            return this.getParent().getComponent(componentAdapter.getComponentKey());
        }
        return null;
    }

    @Override
    public PicoContainer getParent() {
        return this.parent;
    }

    @Override
    public <T> ComponentAdapter<T> removeComponentByInstance(T componentInstance) {
        for (ComponentAdapter<?> componentAdapter : this.getModifiableComponentAdapterList()) {
            if (!this.getLocalInstance(componentAdapter).equals(componentInstance)) continue;
            return this.removeComponent(componentAdapter.getComponentKey());
        }
        return null;
    }

    @Override
    public void start() {
        this.lifecycleState.starting();
        this.startAdapters();
        this.childrenStarted.clear();
        for (PicoContainer child : this.children) {
            this.childrenStarted.add(new WeakReference<PicoContainer>(child));
            if (!(child instanceof Startable)) continue;
            ((Startable)((Object)child)).start();
        }
    }

    @Override
    public void stop() {
        this.lifecycleState.stopping();
        for (PicoContainer child : this.children) {
            if (!this.childStarted(child) || !(child instanceof Startable)) continue;
            ((Startable)((Object)child)).stop();
        }
        this.stopAdapters();
        this.lifecycleState.stopped();
    }

    private boolean childStarted(PicoContainer child) {
        for (WeakReference<PicoContainer> eachChild : this.childrenStarted) {
            PicoContainer ref = (PicoContainer)eachChild.get();
            if (ref == null || !child.equals(ref)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void dispose() {
        if (this.lifecycleState.isStarted()) {
            this.stop();
        }
        this.lifecycleState.disposing();
        for (PicoContainer child : this.children) {
            if (!(child instanceof MutablePicoContainer)) continue;
            ((Disposable)((Object)child)).dispose();
        }
        this.disposeAdapters();
        this.lifecycleState.disposed();
    }

    @Override
    public void setLifecycleState(LifecycleState lifecycleState) {
        this.lifecycleState = lifecycleState;
    }

    @Override
    public MutablePicoContainer makeChildContainer() {
        DefaultPicoContainer pc = new DefaultPicoContainer(this.componentFactory, this.lifecycleStrategy, this, this.componentMonitor);
        this.addChildContainer(pc);
        return pc;
    }

    private void checkCircularChildDependencies(PicoContainer child) {
        String MESSAGE = "Cannot have circular dependency between parent %s and child: %s";
        if (child == this) {
            throw new IllegalArgumentException(String.format("Cannot have circular dependency between parent %s and child: %s", this, child));
        }
        if (child instanceof AbstractDelegatingPicoContainer) {
            AbstractDelegatingPicoContainer delegateChild = (AbstractDelegatingPicoContainer)child;
            while (delegateChild != null) {
                PicoContainer delegateInstance = delegateChild.getDelegate();
                if (this == delegateInstance) {
                    throw new IllegalArgumentException(String.format("Cannot have circular dependency between parent %s and child: %s", this, child));
                }
                if (delegateInstance instanceof AbstractDelegatingPicoContainer) {
                    delegateChild = (AbstractDelegatingPicoContainer)delegateInstance;
                    continue;
                }
                delegateChild = null;
            }
        }
    }

    @Override
    public MutablePicoContainer addChildContainer(PicoContainer child) {
        this.checkCircularChildDependencies(child);
        if (this.children.add(child) && this.lifecycleState.isStarted()) {
            this.childrenStarted.add(new WeakReference<PicoContainer>(child));
        }
        return this;
    }

    @Override
    public boolean removeChildContainer(PicoContainer child) {
        boolean result = this.children.remove(child);
        WeakReference<PicoContainer> foundRef = null;
        for (WeakReference<PicoContainer> eachChild : this.childrenStarted) {
            PicoContainer ref = (PicoContainer)eachChild.get();
            if (!ref.equals(child)) continue;
            foundRef = eachChild;
            break;
        }
        if (foundRef != null) {
            this.childrenStarted.remove(foundRef);
        }
        return result;
    }

    @Override
    public MutablePicoContainer change(Properties ... properties) {
        for (Properties c : properties) {
            Enumeration<?> e = c.propertyNames();
            while (e.hasMoreElements()) {
                String s = (String)e.nextElement();
                this.containerProperties.setProperty(s, c.getProperty(s));
            }
        }
        return this;
    }

    @Override
    public MutablePicoContainer as(Properties ... properties) {
        return new AsPropertiesPicoContainer(properties);
    }

    @Override
    public void accept(PicoVisitor visitor) {
        boolean shouldContinue = visitor.visitContainer(this);
        if (!shouldContinue) {
            return;
        }
        this.componentFactory.accept(visitor);
        ArrayList componentAdapters = new ArrayList(this.getComponentAdapters());
        for (ComponentAdapter componentAdapter : componentAdapters) {
            componentAdapter.accept(visitor);
        }
        ArrayList<PicoContainer> allChildren = new ArrayList<PicoContainer>(this.children);
        for (PicoContainer child : allChildren) {
            child.accept(visitor);
        }
    }

    @Override
    public void changeMonitor(ComponentMonitor monitor) {
        this.componentMonitor = monitor;
        if (this.lifecycleStrategy instanceof ComponentMonitorStrategy) {
            ((ComponentMonitorStrategy)((Object)this.lifecycleStrategy)).changeMonitor(monitor);
        }
        for (ComponentAdapter<?> adapter : this.getModifiableComponentAdapterList()) {
            if (!(adapter instanceof ComponentMonitorStrategy)) continue;
            ((ComponentMonitorStrategy)((Object)adapter)).changeMonitor(monitor);
        }
        for (PicoContainer child : this.children) {
            if (!(child instanceof ComponentMonitorStrategy)) continue;
            ((ComponentMonitorStrategy)((Object)child)).changeMonitor(monitor);
        }
    }

    @Override
    public ComponentMonitor currentMonitor() {
        return this.componentMonitor;
    }

    private void startAdapters() {
        Collection<ComponentAdapter<?>> adapters = this.getComponentAdapters();
        for (ComponentAdapter<?> adapter : adapters) {
            ComponentLifecycle componentLifecycle;
            if (!(adapter instanceof ComponentLifecycle) || !(componentLifecycle = (ComponentLifecycle)((Object)adapter)).componentHasLifecycle()) continue;
            adapter.getComponentInstance(this, (Type)((Object)ComponentAdapter.NOTHING.class));
            this.addOrderedComponentAdapter(adapter);
        }
        adapters = this.getOrderedComponentAdapters();
        ArrayList adaptersClone = new ArrayList(adapters);
        for (ComponentAdapter componentAdapter : adaptersClone) {
            if (!(componentAdapter instanceof ComponentLifecycle)) continue;
            ComponentLifecycle componentLifecycle = (ComponentLifecycle)((Object)componentAdapter);
            componentLifecycle.start(this);
        }
    }

    private void stopAdapters() {
        for (int i = this.getOrderedComponentAdapters().size() - 1; 0 <= i; --i) {
            ComponentLifecycle componentLifecycle;
            ComponentAdapter<?> adapter = this.getOrderedComponentAdapters().get(i);
            if (!(adapter instanceof ComponentLifecycle) || !(componentLifecycle = (ComponentLifecycle)((Object)adapter)).componentHasLifecycle() || !componentLifecycle.isStarted()) continue;
            componentLifecycle.stop(this);
        }
    }

    private void disposeAdapters() {
        for (int i = this.getOrderedComponentAdapters().size() - 1; 0 <= i; --i) {
            ComponentAdapter<?> adapter = this.getOrderedComponentAdapters().get(i);
            if (!(adapter instanceof ComponentLifecycle)) continue;
            ComponentLifecycle componentLifecycle = (ComponentLifecycle)((Object)adapter);
            componentLifecycle.dispose(this);
        }
    }

    protected List<ComponentAdapter<?>> getOrderedComponentAdapters() {
        return this.orderedComponentAdapters;
    }

    protected Map<Object, ComponentAdapter<?>> getComponentKeyToAdapterCache() {
        return this.componentKeyToAdapterCache;
    }

    protected List<ComponentAdapter<?>> getModifiableComponentAdapterList() {
        return this.componentAdapters;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return String.format("%s:%d<%s", this.name != null ? this.name : super.toString(), this.componentAdapters.size(), this.parent != null ? this.parent.toString() : "|");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IntoThreadLocal
    extends ThreadLocal<Type>
    implements Serializable {
        private IntoThreadLocal() {
        }

        @Override
        protected Type initialValue() {
            return ComponentAdapter.NOTHING.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AsPropertiesPicoContainer
    extends AbstractDelegatingMutablePicoContainer {
        private final Properties properties;

        public AsPropertiesPicoContainer(Properties ... props) {
            super(DefaultPicoContainer.this);
            this.properties = (Properties)DefaultPicoContainer.this.containerProperties.clone();
            for (Properties c : props) {
                Enumeration<?> e = c.propertyNames();
                while (e.hasMoreElements()) {
                    String s = (String)e.nextElement();
                    this.properties.setProperty(s, c.getProperty(s));
                }
            }
        }

        @Override
        public MutablePicoContainer as(Properties ... properties) {
            throw new PicoCompositionException("Syntax 'as(FOO).as(BAR)' not allowed, do 'as(FOO, BAR)' instead");
        }

        @Override
        public MutablePicoContainer makeChildContainer() {
            return this.getDelegate().makeChildContainer();
        }

        @Override
        public MutablePicoContainer addComponent(Object componentKey, Object componentImplementationOrInstance, Parameter ... parameters) throws PicoCompositionException {
            return DefaultPicoContainer.this.addComponent(componentKey, componentImplementationOrInstance, this.properties, parameters);
        }

        @Override
        public MutablePicoContainer addComponent(Object implOrInstance) throws PicoCompositionException {
            return DefaultPicoContainer.this.addComponent(implOrInstance, this.properties);
        }

        @Override
        public MutablePicoContainer addAdapter(ComponentAdapter<?> componentAdapter) throws PicoCompositionException {
            return DefaultPicoContainer.this.addAdapter(componentAdapter, this.properties);
        }
    }

    public static class LateInstance
    extends AbstractAdapter {
        private final Object instance;

        private LateInstance(Object componentKey, Object instance) {
            super(componentKey, instance.getClass());
            this.instance = instance;
        }

        public Object getComponentInstance() {
            return this.instance;
        }

        public Object getComponentInstance(PicoContainer container, Type into) throws PicoCompositionException {
            return this.instance;
        }

        public void verify(PicoContainer container) throws PicoCompositionException {
        }

        public String getDescriptor() {
            return "LateInstance";
        }
    }
}

