/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.commons.cli;

import java.net.URI;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pkl.commons.cli.CliBaseOptions;
import org.pkl.commons.cli.CliBugException;
import org.pkl.commons.cli.CliException;
import org.pkl.core.EvaluatorBuilder;
import org.pkl.core.Loggers;
import org.pkl.core.ModuleSource;
import org.pkl.core.PklException;
import org.pkl.core.SecurityManager;
import org.pkl.core.SecurityManagers;
import org.pkl.core.StackFrameTransformer;
import org.pkl.core.StackFrameTransformers;
import org.pkl.core.module.ModuleKeyFactories;
import org.pkl.core.module.ModuleKeyFactory;
import org.pkl.core.module.ModulePathResolver;
import org.pkl.core.project.Project;
import org.pkl.core.resource.ResourceReader;
import org.pkl.core.resource.ResourceReaders;
import org.pkl.core.runtime.CertificateUtils;
import org.pkl.core.settings.PklSettings;
import org.pkl.core.util.IoUtils;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010@\u001a\u00020AH$J\b\u0010B\u001a\u00020CH\u0004J\u0010\u0010D\u001a\u00020#2\u0006\u0010E\u001a\u00020\u001bH\u0004J\u0016\u0010F\u001a\b\u0012\u0004\u0012\u00020G0\u00062\u0006\u0010H\u001a\u00020IH\u0004J\u0016\u0010J\u001a\b\u0012\u0004\u0012\u00020K0\u00062\u0006\u0010H\u001a\u00020IH\u0002J\u0006\u0010L\u001a\u00020AR!\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR!\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000b\u001a\u0004\b\r\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R'\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u00128DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u000b\u001a\u0004\b\u0014\u0010\u0015R'\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u00128DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u000b\u001a\u0004\b\u0018\u0010\u0015R\u001d\u0010\u001a\u001a\u0004\u0018\u00010\u001b8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u000b\u001a\u0004\b\u001c\u0010\u001dR!\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00068DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\u000b\u001a\u0004\b \u0010\tR\u001d\u0010\"\u001a\u0004\u0018\u00010#8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010\u000b\u001a\u0004\b$\u0010%R\u001d\u0010'\u001a\u0004\u0018\u00010(8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b+\u0010\u000b\u001a\u0004\b)\u0010*R\u001d\u0010,\u001a\u0004\u0018\u00010\u001b8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b.\u0010\u000b\u001a\u0004\b-\u0010\u001dR\u001b\u0010/\u001a\u0002008DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b3\u0010\u000b\u001a\u0004\b1\u00102R!\u00104\u001a\u0002058DX\u0084\u0084\u0002\u00a2\u0006\u0012\n\u0004\b:\u0010\u000b\u0012\u0004\b6\u00107\u001a\u0004\b8\u00109R\u001b\u0010;\u001a\u00020<8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b?\u0010\u000b\u001a\u0004\b=\u0010>\u00a8\u0006M"}, d2={"Lorg/pkl/commons/cli/CliCommand;", "", "cliOptions", "Lorg/pkl/commons/cli/CliBaseOptions;", "(Lorg/pkl/commons/cli/CliBaseOptions;)V", "allowedModules", "", "Ljava/util/regex/Pattern;", "getAllowedModules", "()Ljava/util/List;", "allowedModules$delegate", "Lkotlin/Lazy;", "allowedResources", "getAllowedResources", "allowedResources$delegate", "getCliOptions", "()Lorg/pkl/commons/cli/CliBaseOptions;", "environmentVariables", "", "", "getEnvironmentVariables", "()Ljava/util/Map;", "environmentVariables$delegate", "externalProperties", "getExternalProperties", "externalProperties$delegate", "moduleCacheDir", "Ljava/nio/file/Path;", "getModuleCacheDir", "()Ljava/nio/file/Path;", "moduleCacheDir$delegate", "modulePath", "getModulePath", "modulePath$delegate", "project", "Lorg/pkl/core/project/Project;", "getProject", "()Lorg/pkl/core/project/Project;", "project$delegate", "projectSettings", "Lorg/pkl/core/project/Project$EvaluatorSettings;", "getProjectSettings", "()Lorg/pkl/core/project/Project$EvaluatorSettings;", "projectSettings$delegate", "rootDir", "getRootDir", "rootDir$delegate", "securityManager", "Lorg/pkl/core/SecurityManager;", "getSecurityManager", "()Lorg/pkl/core/SecurityManager;", "securityManager$delegate", "settings", "Lorg/pkl/core/settings/PklSettings;", "getSettings$annotations", "()V", "getSettings", "()Lorg/pkl/core/settings/PklSettings;", "settings$delegate", "stackFrameTransformer", "Lorg/pkl/core/StackFrameTransformer;", "getStackFrameTransformer", "()Lorg/pkl/core/StackFrameTransformer;", "stackFrameTransformer$delegate", "doRun", "", "evaluatorBuilder", "Lorg/pkl/core/EvaluatorBuilder;", "loadProject", "projectFile", "moduleKeyFactories", "Lorg/pkl/core/module/ModuleKeyFactory;", "modulePathResolver", "Lorg/pkl/core/module/ModulePathResolver;", "resourceReaders", "Lorg/pkl/core/resource/ResourceReader;", "run", "pkl-commons-cli"})
public abstract class CliCommand {
    @NotNull
    private final CliBaseOptions cliOptions;
    @NotNull
    private final Lazy settings$delegate;
    @NotNull
    private final Lazy project$delegate;
    @NotNull
    private final Lazy projectSettings$delegate;
    @NotNull
    private final Lazy allowedModules$delegate;
    @NotNull
    private final Lazy allowedResources$delegate;
    @NotNull
    private final Lazy rootDir$delegate;
    @NotNull
    private final Lazy environmentVariables$delegate;
    @NotNull
    private final Lazy externalProperties$delegate;
    @NotNull
    private final Lazy moduleCacheDir$delegate;
    @NotNull
    private final Lazy modulePath$delegate;
    @NotNull
    private final Lazy stackFrameTransformer$delegate;
    @NotNull
    private final Lazy securityManager$delegate;

    public CliCommand(@NotNull CliBaseOptions cliOptions) {
        Intrinsics.checkNotNullParameter((Object)cliOptions, (String)"cliOptions");
        this.cliOptions = cliOptions;
        if (!((Collection)this.cliOptions.getCaCertificates()).isEmpty()) {
            CertificateUtils.setupAllX509CertificatesGlobally(this.cliOptions.getCaCertificates());
        }
        this.settings$delegate = LazyKt.lazy((Function0)((Function0)new Function0<PklSettings>(this){
            final /* synthetic */ CliCommand this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final PklSettings invoke() {
                PklSettings pklSettings;
                try {
                    pklSettings = this.this$0.getCliOptions().getNormalizedSettingsModule() != null ? PklSettings.load((ModuleSource)ModuleSource.uri((URI)this.this$0.getCliOptions().getNormalizedSettingsModule())) : PklSettings.loadFromPklHomeDir();
                }
                catch (PklException e) {
                    throw new CliException(e.toString(), 0, 2, null);
                }
                PklSettings pklSettings2 = pklSettings;
                Intrinsics.checkNotNullExpressionValue((Object)pklSettings2, (String)"try {\n      if (cliOptio\u2026ption(e.toString())\n    }");
                return pklSettings2;
            }
        }));
        this.project$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Project>(this){
            final /* synthetic */ CliCommand this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Project invoke() {
                Project project2;
                if (this.this$0.getCliOptions().getNoProject()) {
                    return null;
                }
                Path path = this.this$0.getCliOptions().getNormalizedProjectFile();
                if (path != null) {
                    Path path2 = path;
                    CliCommand cliCommand = this.this$0;
                    Path it = path2;
                    boolean bl = false;
                    project2 = cliCommand.loadProject(it);
                } else {
                    project2 = null;
                }
                return project2;
            }
        }));
        this.projectSettings$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Project.EvaluatorSettings>(this){
            final /* synthetic */ CliCommand this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Project.EvaluatorSettings invoke() {
                if (this.this$0.getCliOptions().getOmitProjectSettings()) {
                    return null;
                }
                Project project2 = this.this$0.getProject();
                return project2 != null ? project2.getSettings() : null;
            }
        }));
        this.allowedModules$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends Pattern>>(this){
            final /* synthetic */ CliCommand this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final List<Pattern> invoke() {
                List<E> list = this.this$0.getCliOptions().getAllowedModules();
                if (list == null) {
                    Project.EvaluatorSettings evaluatorSettings = CliCommand.access$getProjectSettings(this.this$0);
                    list = evaluatorSettings != null ? evaluatorSettings.getAllowedModules() : null;
                    if (list == null) {
                        list = SecurityManagers.defaultAllowedModules;
                    }
                }
                return list;
            }
        }));
        this.allowedResources$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends Pattern>>(this){
            final /* synthetic */ CliCommand this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final List<Pattern> invoke() {
                List<E> list = this.this$0.getCliOptions().getAllowedResources();
                if (list == null) {
                    Project.EvaluatorSettings evaluatorSettings = CliCommand.access$getProjectSettings(this.this$0);
                    list = evaluatorSettings != null ? evaluatorSettings.getAllowedResources() : null;
                    if (list == null) {
                        list = SecurityManagers.defaultAllowedResources;
                    }
                }
                return list;
            }
        }));
        this.rootDir$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Path>(this){
            final /* synthetic */ CliCommand this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Path invoke() {
                Path path = this.this$0.getCliOptions().getNormalizedRootDir();
                if (path == null) {
                    Project.EvaluatorSettings evaluatorSettings = CliCommand.access$getProjectSettings(this.this$0);
                    path = evaluatorSettings != null ? evaluatorSettings.getRootDir() : null;
                }
                return path;
            }
        }));
        this.environmentVariables$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Map<String, ? extends String>>(this){
            final /* synthetic */ CliCommand this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Map<String, String> invoke() {
                Map<String, String> map = this.this$0.getCliOptions().getEnvironmentVariables();
                if (map == null) {
                    Project.EvaluatorSettings evaluatorSettings = CliCommand.access$getProjectSettings(this.this$0);
                    map = evaluatorSettings != null ? evaluatorSettings.getEnv() : null;
                    if (map == null) {
                        map = System.getenv();
                    }
                }
                return map;
            }
        }));
        this.externalProperties$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Map<String, ? extends String>>(this){
            final /* synthetic */ CliCommand this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Map<String, String> invoke() {
                Map<K, V> map = this.this$0.getCliOptions().getExternalProperties();
                if (map == null) {
                    Project.EvaluatorSettings evaluatorSettings = CliCommand.access$getProjectSettings(this.this$0);
                    map = evaluatorSettings != null ? evaluatorSettings.getExternalProperties() : null;
                    if (map == null) {
                        map = MapsKt.emptyMap();
                    }
                }
                return map;
            }
        }));
        this.moduleCacheDir$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Path>(this){
            final /* synthetic */ CliCommand this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Path invoke() {
                Path path;
                if (this.this$0.getCliOptions().getNoCache()) {
                    path = null;
                } else {
                    path = this.this$0.getCliOptions().getNormalizedModuleCacheDir();
                    if (path == null) {
                        Path path2;
                        Project.EvaluatorSettings evaluatorSettings = CliCommand.access$getProjectSettings(this.this$0);
                        if (evaluatorSettings != null) {
                            Project.EvaluatorSettings settings2 = evaluatorSettings;
                            boolean bl = false;
                            path2 = Intrinsics.areEqual((Object)settings2.isNoCache(), (Object)true) ? null : settings2.getModuleCacheDir();
                        } else {
                            path2 = path = null;
                        }
                        if (path2 == null) {
                            Path path3 = IoUtils.getDefaultModuleCacheDir();
                            path = path3;
                            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"getDefaultModuleCacheDir()");
                        }
                    }
                }
                return path;
            }
        }));
        this.modulePath$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends Path>>(this){
            final /* synthetic */ CliCommand this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final List<Path> invoke() {
                List<E> list = this.this$0.getCliOptions().getNormalizedModulePath();
                if (list == null) {
                    Project.EvaluatorSettings evaluatorSettings = CliCommand.access$getProjectSettings(this.this$0);
                    list = evaluatorSettings != null ? evaluatorSettings.getModulePath() : null;
                    if (list == null) {
                        list = CollectionsKt.emptyList();
                    }
                }
                return list;
            }
        }));
        this.stackFrameTransformer$delegate = LazyKt.lazy((Function0)((Function0)new Function0<StackFrameTransformer>(this){
            final /* synthetic */ CliCommand this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final StackFrameTransformer invoke() {
                return this.this$0.getCliOptions().getTestMode() ? StackFrameTransformers.empty : StackFrameTransformers.createDefault((PklSettings)this.this$0.getSettings());
            }
        }));
        this.securityManager$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SecurityManager>(this){
            final /* synthetic */ CliCommand this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final SecurityManager invoke() {
                SecurityManager securityManager2 = SecurityManagers.standard(this.this$0.getAllowedModules(), this.this$0.getAllowedResources(), (Function)SecurityManagers.defaultTrustLevels, (Path)this.this$0.getRootDir());
                Intrinsics.checkNotNullExpressionValue((Object)securityManager2, (String)"standard(\n      allowedM\u2026vels,\n      rootDir\n    )");
                return securityManager2;
            }
        }));
    }

    @NotNull
    protected final CliBaseOptions getCliOptions() {
        return this.cliOptions;
    }

    public final void run() {
        if (this.cliOptions.getTestMode()) {
            IoUtils.setTestMode();
        }
        try {
            this.doRun();
        }
        catch (PklException e) {
            String string = e.getMessage();
            Intrinsics.checkNotNull((Object)string);
            throw new CliException(string, 0, 2, null);
        }
        catch (CliException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CliBugException(e, 0, 2, null);
        }
    }

    protected abstract void doRun();

    @NotNull
    protected final PklSettings getSettings() {
        Lazy lazy = this.settings$delegate;
        return (PklSettings)lazy.getValue();
    }

    protected static /* synthetic */ void getSettings$annotations() {
    }

    @Nullable
    protected final Project getProject() {
        Lazy lazy = this.project$delegate;
        return (Project)lazy.getValue();
    }

    @NotNull
    protected final Project loadProject(@NotNull Path projectFile) {
        List list;
        Intrinsics.checkNotNullParameter((Object)projectFile, (String)"projectFile");
        List list2 = this.cliOptions.getAllowedModules();
        if (list2 == null) {
            list2 = SecurityManagers.defaultAllowedModules;
        }
        if ((list = this.cliOptions.getAllowedResources()) == null) {
            list = SecurityManagers.defaultAllowedResources;
        }
        SecurityManager securityManager2 = SecurityManagers.standard((List)list2, (List)list, (Function)SecurityManagers.defaultTrustLevels, (Path)this.cliOptions.getNormalizedRootDir());
        Intrinsics.checkNotNullExpressionValue((Object)securityManager2, (String)"standard(\n        cliOpt\u2026normalizedRootDir\n      )");
        SecurityManager securityManager3 = securityManager2;
        Map<String, String> map = this.cliOptions.getEnvironmentVariables();
        if (map == null) {
            map = System.getenv();
        }
        Map<String, String> envVars = map;
        StackFrameTransformer stackFrameTransformer2 = IoUtils.isTestMode() ? StackFrameTransformers.empty : StackFrameTransformers.defaultTransformer;
        Project project2 = Project.loadFromPath((Path)projectFile, (SecurityManager)securityManager3, (Duration)this.cliOptions.getTimeout(), (StackFrameTransformer)stackFrameTransformer2, envVars);
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"loadFromPath(\n      proj\u2026rmer,\n      envVars\n    )");
        return project2;
    }

    private final Project.EvaluatorSettings getProjectSettings() {
        Lazy lazy = this.projectSettings$delegate;
        return (Project.EvaluatorSettings)lazy.getValue();
    }

    @NotNull
    protected final List<Pattern> getAllowedModules() {
        Lazy lazy = this.allowedModules$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-allowedModules>(...)");
        return (List)object;
    }

    @NotNull
    protected final List<Pattern> getAllowedResources() {
        Lazy lazy = this.allowedResources$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-allowedResources>(...)");
        return (List)object;
    }

    @Nullable
    protected final Path getRootDir() {
        Lazy lazy = this.rootDir$delegate;
        return (Path)lazy.getValue();
    }

    @NotNull
    protected final Map<String, String> getEnvironmentVariables() {
        Lazy lazy = this.environmentVariables$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-environmentVariables>(...)");
        return (Map)object;
    }

    @NotNull
    protected final Map<String, String> getExternalProperties() {
        Lazy lazy = this.externalProperties$delegate;
        return (Map)lazy.getValue();
    }

    @Nullable
    protected final Path getModuleCacheDir() {
        Lazy lazy = this.moduleCacheDir$delegate;
        return (Path)lazy.getValue();
    }

    @NotNull
    protected final List<Path> getModulePath() {
        Lazy lazy = this.modulePath$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    protected final StackFrameTransformer getStackFrameTransformer() {
        Lazy lazy = this.stackFrameTransformer$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-stackFrameTransformer>(...)");
        return (StackFrameTransformer)object;
    }

    @NotNull
    protected final SecurityManager getSecurityManager() {
        Lazy lazy = this.securityManager$delegate;
        return (SecurityManager)lazy.getValue();
    }

    @NotNull
    protected final List<ModuleKeyFactory> moduleKeyFactories(@NotNull ModulePathResolver modulePathResolver) {
        List list;
        Intrinsics.checkNotNullParameter((Object)modulePathResolver, (String)"modulePathResolver");
        List $this$moduleKeyFactories_u24lambda_u2d0 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        ModuleKeyFactory moduleKeyFactory = ModuleKeyFactories.standardLibrary;
        Intrinsics.checkNotNullExpressionValue((Object)moduleKeyFactory, (String)"standardLibrary");
        $this$moduleKeyFactories_u24lambda_u2d0.add(moduleKeyFactory);
        ModuleKeyFactory moduleKeyFactory2 = ModuleKeyFactories.modulePath((ModulePathResolver)modulePathResolver);
        Intrinsics.checkNotNullExpressionValue((Object)moduleKeyFactory2, (String)"modulePath(modulePathResolver)");
        $this$moduleKeyFactories_u24lambda_u2d0.add(moduleKeyFactory2);
        ModuleKeyFactory moduleKeyFactory3 = ModuleKeyFactories.pkg;
        Intrinsics.checkNotNullExpressionValue((Object)moduleKeyFactory3, (String)"pkg");
        $this$moduleKeyFactories_u24lambda_u2d0.add(moduleKeyFactory3);
        ModuleKeyFactory moduleKeyFactory4 = ModuleKeyFactories.projectpackage;
        Intrinsics.checkNotNullExpressionValue((Object)moduleKeyFactory4, (String)"projectpackage");
        $this$moduleKeyFactories_u24lambda_u2d0.add(moduleKeyFactory4);
        List list2 = ModuleKeyFactories.fromServiceProviders();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"fromServiceProviders()");
        $this$moduleKeyFactories_u24lambda_u2d0.addAll(list2);
        ModuleKeyFactory moduleKeyFactory5 = ModuleKeyFactories.file;
        Intrinsics.checkNotNullExpressionValue((Object)moduleKeyFactory5, (String)"file");
        $this$moduleKeyFactories_u24lambda_u2d0.add(moduleKeyFactory5);
        ModuleKeyFactory moduleKeyFactory6 = ModuleKeyFactories.genericUrl;
        Intrinsics.checkNotNullExpressionValue((Object)moduleKeyFactory6, (String)"genericUrl");
        $this$moduleKeyFactories_u24lambda_u2d0.add(moduleKeyFactory6);
        return CollectionsKt.build((List)list);
    }

    private final List<ResourceReader> resourceReaders(ModulePathResolver modulePathResolver) {
        List list;
        List $this$resourceReaders_u24lambda_u2d1 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        ResourceReader resourceReader = ResourceReaders.environmentVariable();
        Intrinsics.checkNotNullExpressionValue((Object)resourceReader, (String)"environmentVariable()");
        $this$resourceReaders_u24lambda_u2d1.add(resourceReader);
        ResourceReader resourceReader2 = ResourceReaders.externalProperty();
        Intrinsics.checkNotNullExpressionValue((Object)resourceReader2, (String)"externalProperty()");
        $this$resourceReaders_u24lambda_u2d1.add(resourceReader2);
        ResourceReader resourceReader3 = ResourceReaders.modulePath((ModulePathResolver)modulePathResolver);
        Intrinsics.checkNotNullExpressionValue((Object)resourceReader3, (String)"modulePath(modulePathResolver)");
        $this$resourceReaders_u24lambda_u2d1.add(resourceReader3);
        ResourceReader resourceReader4 = ResourceReaders.pkg();
        Intrinsics.checkNotNullExpressionValue((Object)resourceReader4, (String)"pkg()");
        $this$resourceReaders_u24lambda_u2d1.add(resourceReader4);
        ResourceReader resourceReader5 = ResourceReaders.projectpackage();
        Intrinsics.checkNotNullExpressionValue((Object)resourceReader5, (String)"projectpackage()");
        $this$resourceReaders_u24lambda_u2d1.add(resourceReader5);
        ResourceReader resourceReader6 = ResourceReaders.file();
        Intrinsics.checkNotNullExpressionValue((Object)resourceReader6, (String)"file()");
        $this$resourceReaders_u24lambda_u2d1.add(resourceReader6);
        ResourceReader resourceReader7 = ResourceReaders.http();
        Intrinsics.checkNotNullExpressionValue((Object)resourceReader7, (String)"http()");
        $this$resourceReaders_u24lambda_u2d1.add(resourceReader7);
        ResourceReader resourceReader8 = ResourceReaders.https();
        Intrinsics.checkNotNullExpressionValue((Object)resourceReader8, (String)"https()");
        $this$resourceReaders_u24lambda_u2d1.add(resourceReader8);
        return CollectionsKt.build((List)list);
    }

    @NotNull
    protected final EvaluatorBuilder evaluatorBuilder() {
        EvaluatorBuilder evaluatorBuilder;
        ModulePathResolver modulePathResolver = new ModulePathResolver((Iterable)this.getModulePath());
        EvaluatorBuilder $this$evaluatorBuilder_u24lambda_u2d3 = evaluatorBuilder = EvaluatorBuilder.unconfigured().setStackFrameTransformer(this.getStackFrameTransformer());
        boolean bl = false;
        Project project2 = this.getProject();
        if (project2 != null) {
            Project it = project2;
            boolean bl2 = false;
            $this$evaluatorBuilder_u24lambda_u2d3.setProjectDependencies(it.getDependencies());
        }
        EvaluatorBuilder evaluatorBuilder2 = evaluatorBuilder.setSecurityManager(this.getSecurityManager()).setExternalProperties(this.getExternalProperties()).setEnvironmentVariables(this.getEnvironmentVariables()).addModuleKeyFactories((Collection)this.moduleKeyFactories(modulePathResolver)).addResourceReaders((Collection)this.resourceReaders(modulePathResolver)).setLogger(Loggers.stdErr()).setTimeout(this.cliOptions.getTimeout()).setModuleCacheDir(this.getModuleCacheDir());
        Intrinsics.checkNotNullExpressionValue((Object)evaluatorBuilder2, (String)"unconfigured()\n      .se\u2026eCacheDir(moduleCacheDir)");
        return evaluatorBuilder2;
    }

    public static final /* synthetic */ Project.EvaluatorSettings access$getProjectSettings(CliCommand $this) {
        return $this.getProjectSettings();
    }
}

