/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.config.java;

import java.lang.reflect.Type;
import java.util.Map;
import org.pkl.config.java.CompositeConfig;
import org.pkl.config.java.Config;
import org.pkl.config.java.JavaType;
import org.pkl.config.java.LeafConfig;
import org.pkl.config.java.MapConfig;
import org.pkl.config.java.mapper.ValueMapper;
import org.pkl.core.Composite;

abstract class AbstractConfig
implements Config {
    protected final String qualifiedName;
    protected final ValueMapper mapper;

    public AbstractConfig(String qualifiedName, ValueMapper mapper) {
        this.qualifiedName = qualifiedName;
        this.mapper = mapper;
    }

    @Override
    public String getQualifiedName() {
        return this.qualifiedName;
    }

    @Override
    public Config get(String propertyName) {
        String childName;
        Object childValue = this.getRawChildValue(propertyName);
        String string = childName = this.qualifiedName.isEmpty() ? propertyName : this.qualifiedName + "." + propertyName;
        if (childValue instanceof Composite) {
            Composite composite = (Composite)childValue;
            return new CompositeConfig(childName, this.mapper, composite);
        }
        if (childValue instanceof Map) {
            Map map2 = (Map)childValue;
            return new MapConfig(childName, this.mapper, map2);
        }
        return new LeafConfig(childName, this.mapper, childValue);
    }

    @Override
    public <T> T as(Class<T> type) {
        return this.as((Type)type);
    }

    @Override
    public <T> T as(Type type) {
        return this.mapper.map(this.getRawValue(), type);
    }

    @Override
    public <T> T as(JavaType<T> javaType) {
        return this.as(javaType.getType());
    }

    protected abstract Object getRawChildValue(String var1);
}

