/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.config.java.mapper;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import org.pkl.config.java.mapper.ConversionException;
import org.pkl.config.java.mapper.Converter;
import org.pkl.config.java.mapper.ConverterFactory;
import org.pkl.config.java.mapper.Reflection;
import org.pkl.config.java.mapper.ValueMapper;
import org.pkl.core.PClassInfo;
import org.pkl.core.util.Nullable;

class PCollectionToCollection
implements ConverterFactory {
    private static final MethodHandles.Lookup lookup = MethodHandles.lookup();

    PCollectionToCollection() {
    }

    @Override
    public Optional<Converter<?, ?>> create(PClassInfo<?> sourceType, Type targetType) {
        Class<?> targetClass = Reflection.toRawType(targetType);
        if (!sourceType.isConcreteCollectionClass() || !Collection.class.isAssignableFrom(targetClass)) {
            return Optional.empty();
        }
        ParameterizedType iterableType = (ParameterizedType)Reflection.getExactSupertype(targetType, Collection.class);
        Type elementType = Reflection.normalize(iterableType.getActualTypeArguments()[0]);
        return this.createInstantiator(targetClass).map(instantiator -> new ConverterImpl(instantiator, elementType));
    }

    private <T> Optional<Function<Integer, Collection<T>>> createInstantiator(Class<T> clazz) {
        try {
            try {
                MethodHandle ctor2 = lookup.findConstructor(clazz, MethodType.methodType(Void.TYPE, Integer.TYPE, Float.TYPE));
                return Optional.of(length2 -> {
                    try {
                        return ctor2.invoke((int)((float)length2.intValue() / 0.75f) + 1, 0.75f);
                    }
                    catch (Throwable t) {
                        throw new ConversionException(String.format("Error invoking constructor of class `%s`.", clazz), t);
                    }
                });
            }
            catch (NoSuchMethodException e2) {
                try {
                    MethodHandle ctor1 = lookup.findConstructor(clazz, MethodType.methodType(Void.TYPE, Integer.TYPE));
                    return Optional.of(length2 -> {
                        try {
                            return ctor1.invoke((Integer)length2);
                        }
                        catch (Throwable t) {
                            throw new ConversionException(String.format("Error invoking constructor of class `%s`.", clazz), t);
                        }
                    });
                }
                catch (NoSuchMethodException e1) {
                    try {
                        MethodHandle ctor0 = lookup.findConstructor(clazz, MethodType.methodType(Void.TYPE));
                        return Optional.of(length2 -> {
                            try {
                                return ctor0.invoke();
                            }
                            catch (Throwable t) {
                                throw new ConversionException(String.format("Error invoking constructor of class `%s`.", clazz), t);
                            }
                        });
                    }
                    catch (NoSuchMethodException e0) {
                        return Optional.empty();
                    }
                }
            }
        }
        catch (IllegalAccessException e2) {
            throw new ConversionException(String.format("Error accessing constructor of class `%s`.", clazz), e2);
        }
    }

    private static class ConverterImpl<T>
    implements Converter<Collection<Object>, Collection<T>> {
        private final Function<Integer, Collection<T>> targetInstantiator;
        private final Type targetElementType;
        private PClassInfo<Object> cachedElementType = PClassInfo.Unavailable;
        @Nullable
        private Converter<Object, T> cachedConverter;

        private ConverterImpl(Function<Integer, Collection<T>> targetInstantiator, Type targetElementType) {
            this.targetInstantiator = targetInstantiator;
            this.targetElementType = targetElementType;
        }

        @Override
        public Collection<T> convert(Collection<Object> value2, ValueMapper valueMapper) {
            Collection<T> result = this.targetInstantiator.apply(value2.size());
            for (Object elem : value2) {
                if (!this.cachedElementType.isExactClassOf(elem)) {
                    this.cachedElementType = PClassInfo.forValue(elem);
                    this.cachedConverter = valueMapper.getConverter(this.cachedElementType, this.targetElementType);
                }
                assert (this.cachedConverter != null);
                result.add(this.cachedConverter.convert(elem, valueMapper));
            }
            return result;
        }
    }
}

