/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.config.java.mapper;

import java.lang.reflect.Executable;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import org.pkl.core.util.Nullable;
import org.pkl.thirdparty.geantyref.CaptureType;
import org.pkl.thirdparty.geantyref.GenericTypeReflector;

public final class Reflection {
    private Reflection() {
    }

    @Nullable
    public static Class<?> tryLoadClass(String qualifiedName) {
        try {
            return Class.forName(qualifiedName);
        }
        catch (ClassNotFoundException e2) {
            return null;
        }
    }

    public static boolean isMissingTypeArguments(Type type) {
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            Type baseType = wildcardType.getLowerBounds().length > 0 ? wildcardType.getLowerBounds()[0] : wildcardType.getUpperBounds()[0];
            return Reflection.isMissingTypeArguments(baseType);
        }
        return GenericTypeReflector.isMissingTypeParameters(type);
    }

    public static Type normalize(Type type) {
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            Type[] bounds = wildcardType.getLowerBounds();
            if (bounds.length > 0) {
                return bounds[0];
            }
            bounds = wildcardType.getUpperBounds();
            if (bounds.length > 0) {
                return bounds[0];
            }
        }
        return Reflection.getExactSupertype(type, Reflection.toRawType(type));
    }

    public static Class<?> toRawType(Type type) {
        return GenericTypeReflector.erase(type);
    }

    public static <T> Class<T> toWrapperType(Class<T> type) {
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type == Character.TYPE) {
            return Character.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        return type;
    }

    public static Type getArrayElementType(Type type) {
        return GenericTypeReflector.getArrayComponentType(type);
    }

    public static Type getExactSupertype(Type type, Class<?> rawSupertype) {
        return Reflection.uncapture(GenericTypeReflector.getExactSuperType(type, rawSupertype));
    }

    public static Type getExactSubtype(Type type, Class<?> rawSubtype) {
        return Reflection.uncapture(GenericTypeReflector.getExactSubType(type, rawSubtype));
    }

    public static Type[] getExactParameterTypes(Executable m, Type declaringType) {
        return (Type[])Arrays.stream(GenericTypeReflector.getExactParameterTypes(m, GenericTypeReflector.annotate(declaringType))).map(annType -> Reflection.uncapture(annType.getType())).toArray(Type[]::new);
    }

    private static Type uncapture(Type type) {
        if (type instanceof CaptureType) {
            CaptureType captureType = (CaptureType)type;
            return captureType.getWildcardType();
        }
        return type;
    }
}

