/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.config.java.mapper;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.pkl.config.java.mapper.ClassRegistry;
import org.pkl.config.java.mapper.Conversion;
import org.pkl.config.java.mapper.ConversionException;
import org.pkl.config.java.mapper.Converter;
import org.pkl.config.java.mapper.ConverterFactory;
import org.pkl.config.java.mapper.Reflection;
import org.pkl.config.java.mapper.Tuple2;
import org.pkl.config.java.mapper.TypeMapping;
import org.pkl.config.java.mapper.ValueMapper;
import org.pkl.config.java.mapper.ValueMapperBuilder;
import org.pkl.core.PClassInfo;
import org.pkl.core.util.CollectionUtils;

class ValueMapperImpl
implements ValueMapper {
    private final Collection<Conversion<?, ?>> conversions;
    private final Collection<ConverterFactory> factories;
    private final Collection<TypeMapping<?, ?>> typeMappings;
    private final Map<Tuple2<PClassInfo<?>, Type>, Converter<?, ?>> convertersMap;
    private final Map<Class<?>, Class<?>> typeMappingsMap;

    ValueMapperImpl(Collection<Conversion<?, ?>> conversions, Collection<ConverterFactory> factories, Collection<TypeMapping<?, ?>> typeMappings) {
        this.conversions = conversions;
        this.factories = factories;
        this.typeMappings = typeMappings;
        this.convertersMap = CollectionUtils.newHashMap(conversions.size());
        for (Conversion<?, ?> conversion : conversions) {
            this.convertersMap.put(Tuple2.of(conversion.sourceType, conversion.targetType), conversion.converter);
        }
        this.typeMappingsMap = CollectionUtils.newHashMap(typeMappings.size());
        for (TypeMapping typeMapping : typeMappings) {
            this.typeMappingsMap.put(typeMapping.requestedType, typeMapping.implementationType);
        }
    }

    @Override
    public <S, T> T map(S model, Type targetType) {
        PClassInfo<S> sourceType = PClassInfo.forValue(model);
        return this.getConverter(sourceType, targetType).convert(model, this);
    }

    private <S> Class<?> getTargetType(PClassInfo<S> sourceType, Type targetType) {
        Class<?> rawTargetType = Reflection.toRawType(targetType);
        Class<?> determinedClass = ClassRegistry.get(sourceType);
        if (determinedClass == null) {
            return rawTargetType;
        }
        Class<?> rawRegisteredSchema = Reflection.toRawType(determinedClass);
        if (rawTargetType.isAssignableFrom(rawRegisteredSchema)) {
            return rawRegisteredSchema;
        }
        return rawTargetType;
    }

    @Override
    public <S, T> Converter<S, T> getConverter(PClassInfo<S> sourceType, Type targetType) {
        Tuple2<PClassInfo<S>, Type> key2 = Tuple2.of(sourceType, targetType);
        Converter<?, ?> converter = this.convertersMap.get(key2);
        if (converter != null) {
            return converter;
        }
        if (Reflection.isMissingTypeArguments(targetType)) {
            throw new IllegalArgumentException(String.format("Target type `%s` is missing type arguments.", targetType));
        }
        Class<?> rawTargetType = this.getTargetType(sourceType, targetType);
        Class<?> rawImplType = this.typeMappingsMap.getOrDefault(rawTargetType, rawTargetType);
        Type implType = Reflection.getExactSubtype(targetType, rawImplType);
        Tuple2<PClassInfo<S>, Type> implKey = Tuple2.of(sourceType, implType);
        Converter<?, ?> implConverter = this.convertersMap.get(implKey);
        if (implConverter != null) {
            this.convertersMap.put(key2, implConverter);
            return implConverter;
        }
        for (ConverterFactory factory : this.factories) {
            Optional<Converter<?, ?>> newConverter = factory.create(sourceType, implType);
            if (!newConverter.isPresent()) continue;
            this.convertersMap.put(key2, newConverter.get());
            return newConverter.get();
        }
        throw new ConversionException(String.format("Cannot convert `%s` to `%s` because no conversion was found.", sourceType.getQualifiedName(), targetType.getTypeName()));
    }

    @Override
    public ValueMapperBuilder toBuilder() {
        return ValueMapperBuilder.unconfigured().setConversions(this.conversions).setConverterFactories(this.factories).setTypeMappings(this.typeMappings);
    }
}

