/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core;

import org.pkl.core.Logger;
import org.pkl.core.StackFrame;

public final class BufferedLogger
implements Logger {
    private final StringBuilder builder = new StringBuilder();
    private final Logger logger;

    public BufferedLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void trace(String message, StackFrame frame) {
        this.builder.append(message).append("\n");
        this.logger.trace(message, frame);
    }

    @Override
    public void warn(String message, StackFrame frame) {
        this.builder.append(message).append("\n");
        this.logger.warn(message, frame);
    }

    public void clear() {
        this.builder.setLength(0);
    }

    public String getLogs() {
        return this.builder.toString();
    }
}

