/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.pkl.core.Composite;
import org.pkl.core.DataSize;
import org.pkl.core.Duration;
import org.pkl.core.PClass;
import org.pkl.core.PModule;
import org.pkl.core.PNull;
import org.pkl.core.PObject;
import org.pkl.core.Pair;
import org.pkl.core.RendererException;
import org.pkl.core.TypeAlias;
import org.pkl.core.ValueConverter;
import org.pkl.core.ValueRenderer;
import org.pkl.core.util.Nullable;
import org.pkl.core.util.properties.PropertiesUtils;

final class PropertiesRenderer
implements ValueRenderer {
    private final Writer writer;
    private final boolean omitNullProperties;
    private final boolean restrictCharset;

    public PropertiesRenderer(Writer writer, boolean omitNullProperties, boolean restrictCharset) {
        this.writer = writer;
        this.omitNullProperties = omitNullProperties;
        this.restrictCharset = restrictCharset;
    }

    @Override
    public void renderDocument(Object value2) {
        new Visitor().renderDocument(value2);
    }

    @Override
    public void renderValue(Object value2) {
        new Visitor().renderValue(value2);
    }

    private class Visitor
    implements ValueConverter<String> {
        private Visitor() {
        }

        public void renderDocument(Object value2) {
            if (value2 instanceof Composite) {
                Composite composite = (Composite)value2;
                this.doVisitMap(null, composite.getProperties());
            } else if (value2 instanceof Map) {
                Map map2 = (Map)value2;
                this.doVisitMap(null, map2);
            } else if (value2 instanceof Pair) {
                Pair pair = (Pair)value2;
                this.doVisitKeyAndValue(null, pair.getFirst(), pair.getSecond());
            } else {
                throw new RendererException(String.format("The top-level value of a Java properties file must have type `Composite`, `Map`, or `Pair`, but got type `%s`.", value2.getClass().getTypeName()));
            }
        }

        public void renderValue(Object value2) {
            this.write((String)this.convert(value2), false, PropertiesRenderer.this.restrictCharset);
        }

        @Override
        public String convertNull() {
            return "";
        }

        @Override
        public String convertString(String value2) {
            return value2;
        }

        @Override
        public String convertInt(Long value2) {
            return value2.toString();
        }

        @Override
        public String convertFloat(Double value2) {
            return value2.toString();
        }

        @Override
        public String convertBoolean(Boolean value2) {
            return value2.toString();
        }

        @Override
        public String convertDuration(Duration value2) {
            throw new RendererException(String.format("Values of type `Duration` cannot be rendered as Properties. Value: %s", value2));
        }

        @Override
        public String convertDataSize(DataSize value2) {
            throw new RendererException(String.format("Values of type `DataSize` cannot be rendered as Properties. Value: %s", value2));
        }

        @Override
        public String convertPair(Pair<?, ?> value2) {
            throw new RendererException(String.format("Values of type `Pair` cannot be rendered as Properties. Value: %s", value2));
        }

        @Override
        public String convertList(List<?> value2) {
            throw new RendererException(String.format("Values of type `List` cannot be rendered as Properties. Value: %s", value2));
        }

        @Override
        public String convertSet(Set<?> value2) {
            throw new RendererException(String.format("Values of type `Set` cannot be rendered as Properties. Value: %s", value2));
        }

        @Override
        public String convertMap(Map<?, ?> value2) {
            throw new RendererException(String.format("Values of type `Map` cannot be rendered as Properties. Value: %s", value2));
        }

        @Override
        public String convertObject(PObject value2) {
            throw new RendererException(String.format("Values of type `Object` cannot be rendered as Properties. Value: %s", value2));
        }

        @Override
        public String convertModule(PModule value2) {
            throw new RendererException(String.format("Values of type `Module` cannot be rendered as Properties. Value: %s", value2));
        }

        @Override
        public String convertClass(PClass value2) {
            throw new RendererException(String.format("Values of type `Class` cannot be rendered as Properties. Value: %s", value2.getSimpleName()));
        }

        @Override
        public String convertTypeAlias(TypeAlias value2) {
            throw new RendererException(String.format("Values of type `TypeAlias` cannot be rendered as Properties. Value: %s", value2.getSimpleName()));
        }

        @Override
        public String convertRegex(Pattern value2) {
            throw new RendererException(String.format("Values of type `Regex` cannot be rendered as Properties. Value: %s", value2));
        }

        private void doVisitMap(@Nullable String keyPrefix, Map<?, ?> map2) {
            for (Map.Entry<?, ?> entry : map2.entrySet()) {
                this.doVisitKeyAndValue(keyPrefix, entry.getKey(), entry.getValue());
            }
        }

        private void doVisitKeyAndValue(@Nullable String keyPrefix, Object key2, Object value2) {
            String keyString;
            if (PropertiesRenderer.this.omitNullProperties && value2 instanceof PNull) {
                return;
            }
            String string = keyString = keyPrefix == null ? (String)this.convert(key2) : keyPrefix + "." + (String)this.convert(key2);
            if (value2 instanceof Composite) {
                Composite composite = (Composite)value2;
                this.doVisitMap(keyString, composite.getProperties());
            } else if (value2 instanceof Map) {
                Map map2 = (Map)value2;
                this.doVisitMap(keyString, map2);
            } else {
                this.write(keyString, true, PropertiesRenderer.this.restrictCharset);
                this.writeSeparator();
                this.write((String)this.convert(value2), false, PropertiesRenderer.this.restrictCharset);
                this.writeLineBreak();
            }
        }

        private void write(String value2, boolean escapeSpace, boolean restrictCharset) {
            try {
                PropertiesRenderer.this.writer.write(PropertiesUtils.renderPropertiesKeyOrValue(value2, escapeSpace, restrictCharset));
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        }

        private void writeSeparator() {
            try {
                PropertiesRenderer.this.writer.write(32);
                PropertiesRenderer.this.writer.write(61);
                PropertiesRenderer.this.writer.write(32);
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        }

        private void writeLineBreak() {
            try {
                PropertiesRenderer.this.writer.write(10);
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        }
    }
}

