/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.builder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.pkl.core.ast.builder.AbstractAstBuilder;
import org.pkl.core.module.ModuleKey;
import org.pkl.core.module.ResolvedModuleKey;
import org.pkl.core.parser.LexParseException;
import org.pkl.core.parser.Parser;
import org.pkl.core.parser.antlr.PklParser;
import org.pkl.core.runtime.VmExceptionBuilder;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.util.IoUtils;
import org.pkl.core.util.Nullable;
import org.pkl.thirdparty.antlr.v4.runtime.Token;
import org.pkl.thirdparty.truffle.api.source.Source;
import org.pkl.thirdparty.truffle.api.source.SourceSection;

public class ImportsAndReadsParser
extends AbstractAstBuilder<List<Entry>> {
    @Nullable
    public static List<Entry> parse(ModuleKey moduleKey, ResolvedModuleKey resolvedModuleKey) throws IOException {
        Parser parser = new Parser();
        String text = resolvedModuleKey.loadSource();
        Source source = VmUtils.createSource(moduleKey, text);
        ImportsAndReadsParser importListParser = new ImportsAndReadsParser(source);
        try {
            return parser.parseModule(text).accept(importListParser);
        }
        catch (LexParseException e2) {
            String moduleName = IoUtils.inferModuleName(moduleKey);
            throw VmUtils.toVmException(e2, source, moduleName);
        }
    }

    public ImportsAndReadsParser(Source source) {
        super(source);
    }

    @Override
    protected VmExceptionBuilder exceptionBuilder() {
        return new VmExceptionBuilder();
    }

    @Override
    @Nullable
    public List<Entry> visitModuleExtendsOrAmendsClause(PklParser.ModuleExtendsOrAmendsClauseContext ctx) {
        String importStr = this.doVisitSingleLineConstantStringPart(ctx.stringConstant().ts);
        SourceSection sourceSection = this.createSourceSection(ctx.stringConstant());
        return Collections.singletonList(new Entry(true, false, ctx.EXTENDS() != null, ctx.AMENDS() != null, importStr, sourceSection));
    }

    @Override
    public List<Entry> visitImportClause(PklParser.ImportClauseContext ctx) {
        String importStr = this.doVisitSingleLineConstantStringPart(ctx.stringConstant().ts);
        SourceSection sourceSection = this.createSourceSection(ctx.stringConstant());
        return Collections.singletonList(new Entry(true, ctx.t.getType() == 16, false, false, importStr, sourceSection));
    }

    @Override
    public List<Entry> visitImportExpr(PklParser.ImportExprContext ctx) {
        String importStr = this.doVisitSingleLineConstantStringPart(ctx.stringConstant().ts);
        SourceSection sourceSection = this.createSourceSection(ctx.stringConstant());
        return Collections.singletonList(new Entry(true, ctx.t.getType() == 16, false, false, importStr, sourceSection));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<Entry> visitReadExpr(PklParser.ReadExprContext ctx) {
        String importString;
        PklParser.ExprContext expr = ctx.expr();
        if (!(expr instanceof PklParser.SingleLineStringLiteralContext)) {
            return Collections.emptyList();
        }
        PklParser.SingleLineStringLiteralContext slCtx = (PklParser.SingleLineStringLiteralContext)expr;
        List<? extends PklParser.SingleLineStringPartContext> singleParts = slCtx.singleLineStringPart();
        if (singleParts.isEmpty()) {
            importString = "";
            return Collections.singletonList(new Entry(false, ctx.t.getType() == 29, false, false, importString, this.createSourceSection(slCtx)));
        } else {
            if (singleParts.size() != 1) return Collections.emptyList();
            List<Token> ts = singleParts.get((int)0).ts;
            if (ts.isEmpty()) return Collections.emptyList();
            importString = this.doVisitSingleLineConstantStringPart(ts);
        }
        return Collections.singletonList(new Entry(false, ctx.t.getType() == 29, false, false, importString, this.createSourceSection(slCtx)));
    }

    @Override
    @Nullable
    protected List<Entry> aggregateResult(@Nullable List<Entry> aggregate, @Nullable List<Entry> nextResult) {
        if (aggregate == null || aggregate.isEmpty()) {
            return nextResult;
        }
        if (nextResult == null || nextResult.isEmpty()) {
            return aggregate;
        }
        ArrayList<Entry> ret = new ArrayList<Entry>(aggregate.size() + nextResult.size());
        ret.addAll(aggregate);
        ret.addAll(nextResult);
        return ret;
    }

    public record Entry(boolean isModule, boolean isGlob, boolean isExtends, boolean isAmends, String stringValue, SourceSection sourceSection) {
    }
}

