/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.generator;

import org.pkl.core.ast.expression.generator.GeneratorMemberNode;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmDynamic;
import org.pkl.core.runtime.VmListing;
import org.pkl.core.util.EconomicMaps;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.dsl.Fallback;
import org.pkl.thirdparty.truffle.api.dsl.ImportStatic;
import org.pkl.thirdparty.truffle.api.dsl.Specialization;

@ImportStatic(value={BaseModule.class})
public abstract class GeneratorElementNode
extends GeneratorMemberNode {
    private final ObjectMember element;

    protected GeneratorElementNode(ObjectMember element) {
        super(element.getSourceSection());
        this.element = element;
    }

    @Specialization
    protected void evalDynamic(VmDynamic parent, GeneratorMemberNode.ObjectData data) {
        this.addElement(data);
    }

    @Specialization
    protected void evalListing(VmListing parent, GeneratorMemberNode.ObjectData data) {
        this.addElement(data);
    }

    @Specialization(guards={"parent == getDynamicClass()"})
    protected void evalDynamicClass(VmClass parent, GeneratorMemberNode.ObjectData data) {
        this.addElement(data);
    }

    @Specialization(guards={"parent == getListingClass()"})
    protected void evalListingClass(VmClass parent, GeneratorMemberNode.ObjectData data) {
        this.addElement(data);
    }

    @Fallback
    void fallback(Object parent, GeneratorMemberNode.ObjectData data) {
        CompilerDirectives.transferToInterpreter();
        throw this.exceptionBuilder().evalError("objectCannotHaveElement", parent).build();
    }

    private void addElement(GeneratorMemberNode.ObjectData data) {
        long index = data.length;
        EconomicMaps.put(data.members, index, this.element);
        ++data.length;
        data.persistForBindings(index);
    }
}

