/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.member;

import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.member.ClassMethod;
import org.pkl.core.ast.type.TypeNode;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.VmDynamic;
import org.pkl.core.runtime.VmLanguage;
import org.pkl.core.runtime.VmObjectLike;
import org.pkl.core.util.LateInit;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.frame.VirtualFrame;
import org.pkl.thirdparty.truffle.api.nodes.Node;
import org.pkl.thirdparty.truffle.api.source.SourceSection;

public final class InferParentWithinMethodNode
extends ExpressionNode {
    private final VmLanguage language;
    private final Identifier methodName;
    @Node.Child
    private ExpressionNode ownerNode;
    @CompilerDirectives.CompilationFinal
    @LateInit
    private Object inferredParent;

    public InferParentWithinMethodNode(SourceSection sourceSection, VmLanguage language, Identifier methodName, ExpressionNode ownerNode) {
        super(sourceSection);
        this.language = language;
        this.methodName = methodName;
        this.ownerNode = ownerNode;
    }

    @Override
    public Object executeGeneric(VirtualFrame frame) {
        if (this.inferredParent != null) {
            return this.inferredParent;
        }
        CompilerDirectives.transferToInterpreter();
        VmObjectLike owner = (VmObjectLike)this.ownerNode.executeGeneric(frame);
        assert (owner.isPrototype());
        ClassMethod method = owner.getVmClass().getDeclaredMethod(this.methodName);
        assert (method != null);
        TypeNode returnTypeNode = method.getReturnTypeNode();
        if (returnTypeNode == null || returnTypeNode instanceof TypeNode.UnknownTypeNode) {
            this.inferredParent = VmDynamic.empty();
            this.ownerNode = null;
            return this.inferredParent;
        }
        Object returnTypeDefaultValue = returnTypeNode.createDefaultValue(this.language, method.getHeaderSection(), method.getQualifiedName());
        if (returnTypeDefaultValue != null) {
            this.inferredParent = returnTypeDefaultValue;
            this.ownerNode = null;
            return this.inferredParent;
        }
        throw this.exceptionBuilder().evalError("cannotInferParent", new Object[0]).build();
    }
}

