/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.member;

import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.member.ClassMethod;
import org.pkl.core.runtime.VmObjectLike;
import org.pkl.thirdparty.truffle.api.frame.VirtualFrame;
import org.pkl.thirdparty.truffle.api.nodes.DirectCallNode;
import org.pkl.thirdparty.truffle.api.nodes.ExplodeLoop;
import org.pkl.thirdparty.truffle.api.nodes.Node;
import org.pkl.thirdparty.truffle.api.source.SourceSection;

public final class InvokeMethodDirectNode
extends ExpressionNode {
    private final VmObjectLike owner;
    @Node.Child
    private ExpressionNode receiverNode;
    @Node.Children
    private final ExpressionNode[] argumentNodes;
    private final boolean isInIterable;
    @Node.Child
    private DirectCallNode callNode;

    public InvokeMethodDirectNode(SourceSection sourceSection, ClassMethod method, ExpressionNode receiverNode, ExpressionNode[] argumentNodes, boolean isInIterable) {
        super(sourceSection);
        this.owner = method.getOwner();
        this.receiverNode = receiverNode;
        this.argumentNodes = argumentNodes;
        this.isInIterable = isInIterable;
        this.callNode = DirectCallNode.create(method.getCallTarget(sourceSection));
    }

    @Override
    @ExplodeLoop
    public Object executeGeneric(VirtualFrame frame) {
        Object[] args = new Object[3 + this.argumentNodes.length];
        args[0] = this.receiverNode.executeGeneric(frame);
        args[1] = this.owner;
        args[2] = this.isInIterable;
        for (int i = 0; i < this.argumentNodes.length; ++i) {
            args[3 + i] = this.argumentNodes[i].executeGeneric(frame);
        }
        return this.callNode.call(args);
    }
}

