/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.member;

import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.runtime.VmObjectLike;
import org.pkl.core.runtime.VmUtils;
import org.pkl.thirdparty.truffle.api.CallTarget;
import org.pkl.thirdparty.truffle.api.frame.Frame;
import org.pkl.thirdparty.truffle.api.frame.VirtualFrame;
import org.pkl.thirdparty.truffle.api.nodes.DirectCallNode;
import org.pkl.thirdparty.truffle.api.nodes.ExplodeLoop;
import org.pkl.thirdparty.truffle.api.nodes.Node;
import org.pkl.thirdparty.truffle.api.source.SourceSection;

public final class InvokeMethodLexicalNode
extends ExpressionNode {
    @Node.Children
    private final ExpressionNode[] argumentNodes;
    private final int levelsUp;
    @Node.Child
    private DirectCallNode callNode;
    private final boolean isInIterable;

    InvokeMethodLexicalNode(SourceSection sourceSection, CallTarget callTarget, int levelsUp, ExpressionNode[] argumentNodes, boolean isInIterable) {
        super(sourceSection);
        this.levelsUp = levelsUp;
        this.argumentNodes = argumentNodes;
        this.callNode = DirectCallNode.create(callTarget);
        this.isInIterable = isInIterable;
    }

    @Override
    @ExplodeLoop
    public Object executeGeneric(VirtualFrame frame) {
        Object[] args = new Object[3 + this.argumentNodes.length];
        Frame enclosingFrame = this.getEnclosingFrame(frame);
        args[0] = VmUtils.getReceiver(enclosingFrame);
        args[1] = VmUtils.getOwner(enclosingFrame);
        args[2] = this.isInIterable;
        for (int i = 0; i < this.argumentNodes.length; ++i) {
            args[3 + i] = this.argumentNodes[i].executeGeneric(frame);
        }
        return this.callNode.call(args);
    }

    @ExplodeLoop
    private Frame getEnclosingFrame(VirtualFrame frame) {
        if (this.levelsUp == 0) {
            return frame;
        }
        VmObjectLike owner = VmUtils.getOwner(frame);
        for (int i = 1; i < this.levelsUp; ++i) {
            owner = owner.getEnclosingOwner();
            assert (owner != null);
        }
        return owner.getEnclosingFrame();
    }
}

