/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.member;

import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.MemberLookupMode;
import org.pkl.core.ast.internal.GetClassNode;
import org.pkl.core.ast.member.ClassMethod;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmFunction;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.RootCallTarget;
import org.pkl.thirdparty.truffle.api.dsl.Cached;
import org.pkl.thirdparty.truffle.api.dsl.ImportStatic;
import org.pkl.thirdparty.truffle.api.dsl.NodeChild;
import org.pkl.thirdparty.truffle.api.dsl.NodeChildren;
import org.pkl.thirdparty.truffle.api.dsl.Specialization;
import org.pkl.thirdparty.truffle.api.frame.VirtualFrame;
import org.pkl.thirdparty.truffle.api.nodes.DirectCallNode;
import org.pkl.thirdparty.truffle.api.nodes.ExplodeLoop;
import org.pkl.thirdparty.truffle.api.nodes.IndirectCallNode;
import org.pkl.thirdparty.truffle.api.nodes.Node;
import org.pkl.thirdparty.truffle.api.source.SourceSection;

@ImportStatic(value={Identifier.class})
@NodeChildren(value={@NodeChild(value="receiverNode", type=ExpressionNode.class), @NodeChild(value="receiverClassNode", type=GetClassNode.class, executeWith={"receiverNode"})})
public abstract class InvokeMethodVirtualNode
extends ExpressionNode {
    protected final Identifier methodName;
    @Node.Children
    private final ExpressionNode[] argumentNodes;
    private final MemberLookupMode lookupMode;
    private final boolean needsConst;
    private final boolean isInIterable;

    protected InvokeMethodVirtualNode(SourceSection sourceSection, Identifier methodName, ExpressionNode[] argumentNodes, MemberLookupMode lookupMode, boolean needsConst, boolean isInIterable) {
        super(sourceSection);
        this.methodName = methodName;
        this.argumentNodes = argumentNodes;
        this.lookupMode = lookupMode;
        this.needsConst = needsConst;
        this.isInIterable = isInIterable;
    }

    protected InvokeMethodVirtualNode(SourceSection sourceSection, Identifier methodName, ExpressionNode[] argumentNodes, MemberLookupMode lookupMode, boolean isInIterable) {
        this(sourceSection, methodName, argumentNodes, lookupMode, false, isInIterable);
    }

    public abstract Object executeWith(VirtualFrame var1, Object var2, VmClass var3);

    @ExplodeLoop
    @Specialization(guards={"methodName == APPLY", "receiver.getCallTarget() == cachedCallTarget"})
    protected Object evalFunctionCached(VirtualFrame frame, VmFunction receiver, VmClass receiverClass, @Cached(value="receiver.getCallTarget()") RootCallTarget cachedCallTarget, @Cached(value="create(cachedCallTarget)") DirectCallNode callNode) {
        Object[] args = new Object[3 + this.argumentNodes.length];
        args[0] = receiver.getThisValue();
        args[1] = receiver;
        args[2] = this.isInIterable;
        for (int i = 0; i < this.argumentNodes.length; ++i) {
            args[3 + i] = this.argumentNodes[i].executeGeneric(frame);
        }
        return callNode.call(args);
    }

    @ExplodeLoop
    @Specialization(guards={"methodName == APPLY"}, replaces={"evalFunctionCached"})
    protected Object evalFunction(VirtualFrame frame, VmFunction receiver, VmClass receiverClass, @Cached.Exclusive @Cached(value="create()") IndirectCallNode callNode) {
        Object[] args = new Object[3 + this.argumentNodes.length];
        args[0] = receiver.getThisValue();
        args[1] = receiver;
        args[2] = this.isInIterable;
        for (int i = 0; i < this.argumentNodes.length; ++i) {
            args[3 + i] = this.argumentNodes[i].executeGeneric(frame);
        }
        return callNode.call(receiver.getCallTarget(), args);
    }

    @ExplodeLoop
    @Specialization(guards={"receiverClass == cachedReceiverClass"})
    protected Object evalCached(VirtualFrame frame, Object receiver, VmClass receiverClass, @Cached(value="receiverClass") VmClass cachedReceiverClass, @Cached(value="resolveMethod(receiverClass)") ClassMethod method, @Cached(value="create(method.getCallTarget(sourceSection))") DirectCallNode callNode) {
        Object[] args = new Object[3 + this.argumentNodes.length];
        args[0] = receiver;
        args[1] = method.getOwner();
        args[2] = this.isInIterable;
        for (int i = 0; i < this.argumentNodes.length; ++i) {
            args[3 + i] = this.argumentNodes[i].executeGeneric(frame);
        }
        return callNode.call(args);
    }

    @ExplodeLoop
    @Specialization(replaces={"evalCached"})
    protected Object eval(VirtualFrame frame, Object receiver, VmClass receiverClass, @Cached.Exclusive @Cached(value="create()") IndirectCallNode callNode) {
        ClassMethod method = this.resolveMethod(receiverClass);
        Object[] args = new Object[3 + this.argumentNodes.length];
        args[0] = receiver;
        args[1] = method.getOwner();
        args[2] = this.isInIterable;
        for (int i = 0; i < this.argumentNodes.length; ++i) {
            args[3 + i] = this.argumentNodes[i].executeGeneric(frame);
        }
        return callNode.call(method.getCallTarget(), args);
    }

    protected ClassMethod resolveMethod(VmClass receiverClass) {
        ClassMethod method = receiverClass.getMethod(this.methodName);
        if (method != null) {
            this.checkConst(method);
            return method;
        }
        CompilerDirectives.transferToInterpreter();
        throw this.exceptionBuilder().cannotFindMethod(receiverClass.getPrototype(), this.methodName, this.argumentNodes.length, this.lookupMode != MemberLookupMode.EXPLICIT_RECEIVER).build();
    }

    private void checkConst(ClassMethod method) {
        if (this.needsConst && !method.isConst()) {
            CompilerDirectives.transferToInterpreter();
            throw this.exceptionBuilder().evalError("methodMustBeConst", this.methodName.toString()).build();
        }
    }
}

