/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.unary;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.pkl.core.SecurityManagerException;
import org.pkl.core.ast.expression.unary.UnaryExpressionNode;
import org.pkl.core.externalreader.ExternalReaderProcessException;
import org.pkl.core.module.ModuleKey;
import org.pkl.core.packages.PackageLoadError;
import org.pkl.core.runtime.VmContext;
import org.pkl.core.util.IoUtils;
import org.pkl.core.util.Nullable;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.nodes.Node;
import org.pkl.thirdparty.truffle.api.source.SourceSection;

public abstract class AbstractReadNode
extends UnaryExpressionNode {
    protected final ModuleKey currentModule;

    protected AbstractReadNode(SourceSection sourceSection, ModuleKey currentModule) {
        super(sourceSection);
        this.currentModule = currentModule;
    }

    @CompilerDirectives.TruffleBoundary
    protected final URI parseUri(String resourceUri) {
        try {
            return IoUtils.toUri(resourceUri);
        }
        catch (URISyntaxException e2) {
            throw this.exceptionBuilder().evalError("invalidResourceUri", resourceUri).withHint(e2.getReason()).build();
        }
    }

    @CompilerDirectives.TruffleBoundary
    @Nullable
    protected final Object doRead(String resourceUri, VmContext context, Node readNode) {
        URI resolvedUri = this.resolveResource(this.currentModule, resourceUri);
        return context.getResourceManager().read(resolvedUri, readNode).orElse(null);
    }

    private URI resolveResource(ModuleKey moduleKey, String resourceUri) {
        URI resolvedUri;
        URI parsedUri = this.parseUri(resourceUri);
        VmContext context = VmContext.get(this);
        try {
            resolvedUri = IoUtils.resolve(context.getSecurityManager(), moduleKey, parsedUri);
        }
        catch (FileNotFoundException e2) {
            throw this.exceptionBuilder().evalError("cannotFindResource", resourceUri).build();
        }
        catch (URISyntaxException e3) {
            throw this.exceptionBuilder().evalError("invalidResourceUri", resourceUri).withHint(e3.getReason()).build();
        }
        catch (IOException e4) {
            throw this.exceptionBuilder().evalError("ioErrorReadingResource", resourceUri).withHint(e4.getMessage()).build();
        }
        catch (SecurityManagerException | PackageLoadError e5) {
            throw this.exceptionBuilder().withCause(e5).build();
        }
        catch (ExternalReaderProcessException e6) {
            throw this.exceptionBuilder().evalError("externalReaderFailure", new Object[0]).withCause(e6).build();
        }
        if (!resolvedUri.isAbsolute()) {
            throw this.exceptionBuilder().evalError("cannotHaveRelativeResource", moduleKey.getUri()).build();
        }
        return resolvedUri;
    }
}

