/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.unary;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.pkl.core.SecurityManagerException;
import org.pkl.core.ast.expression.unary.AbstractReadNode;
import org.pkl.core.ast.expression.unary.ReadGlobMemberBodyNode;
import org.pkl.core.ast.member.SharedMemberNode;
import org.pkl.core.externalreader.ExternalReaderProcessException;
import org.pkl.core.http.HttpClientInitException;
import org.pkl.core.module.ModuleKey;
import org.pkl.core.resource.ResourceReader;
import org.pkl.core.runtime.VmContext;
import org.pkl.core.runtime.VmLanguage;
import org.pkl.core.runtime.VmMapping;
import org.pkl.core.runtime.VmObjectBuilder;
import org.pkl.core.util.GlobResolver;
import org.pkl.core.util.IoUtils;
import org.pkl.core.util.LateInit;
import org.pkl.thirdparty.graalvm.collections.EconomicMap;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.dsl.Specialization;
import org.pkl.thirdparty.truffle.api.frame.FrameDescriptor;
import org.pkl.thirdparty.truffle.api.nodes.Node;
import org.pkl.thirdparty.truffle.api.nodes.NodeInfo;
import org.pkl.thirdparty.truffle.api.source.SourceSection;

@NodeInfo(shortName="read*")
public abstract class ReadGlobNode
extends AbstractReadNode {
    private final EconomicMap<String, VmMapping> cachedResults = EconomicMap.create();
    @Node.Child
    @LateInit
    private SharedMemberNode memberNode;

    protected ReadGlobNode(SourceSection sourceSection, ModuleKey currentModule) {
        super(sourceSection, currentModule);
    }

    private SharedMemberNode getMemberNode() {
        if (this.memberNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            VmLanguage language = VmLanguage.get(this);
            this.memberNode = new SharedMemberNode(this.sourceSection, this.sourceSection, "", language, new FrameDescriptor(), new ReadGlobMemberBodyNode(this.sourceSection));
        }
        return this.memberNode;
    }

    @Specialization
    @CompilerDirectives.TruffleBoundary
    public Object read(String globPattern) {
        VmMapping cachedResult = (VmMapping)this.cachedResults.get(globPattern);
        if (cachedResult != null) {
            return cachedResult;
        }
        if (globPattern.startsWith("...")) {
            throw this.exceptionBuilder().evalError("cannotGlobTripleDots", new Object[0]).build();
        }
        URI globUri = this.parseUri(globPattern);
        VmContext context = VmContext.get(this);
        try {
            URI resolvedUri = IoUtils.resolve(context.getSecurityManager(), this.currentModule, globUri);
            ResourceReader reader = context.getResourceManager().getReader(resolvedUri, this);
            if (!reader.isGlobbable()) {
                throw this.exceptionBuilder().evalError("cannotGlobUri", globUri, globUri.getScheme()).build();
            }
            Map<String, GlobResolver.ResolvedGlobElement> resolvedElements = GlobResolver.resolveGlob(context.getSecurityManager(), reader, this.currentModule, this.currentModule.getUri(), globPattern);
            VmObjectBuilder builder = new VmObjectBuilder(resolvedElements.size());
            for (Map.Entry<String, GlobResolver.ResolvedGlobElement> entry : resolvedElements.entrySet()) {
                builder.addEntry((Object)entry.getKey(), this.getMemberNode());
            }
            cachedResult = builder.toMapping(resolvedElements);
            this.cachedResults.put(globPattern, cachedResult);
            return cachedResult;
        }
        catch (IOException e2) {
            throw this.exceptionBuilder().evalError("ioErrorResolvingGlob", globPattern).withCause(e2).build();
        }
        catch (URISyntaxException | SecurityManagerException | HttpClientInitException e3) {
            throw this.exceptionBuilder().withCause(e3).build();
        }
        catch (GlobResolver.InvalidGlobPatternException e4) {
            throw this.exceptionBuilder().evalError("invalidGlobPattern", globPattern).withHint(e4.getMessage()).build();
        }
        catch (ExternalReaderProcessException e5) {
            throw this.exceptionBuilder().evalError("externalReaderFailure", new Object[0]).withCause(e5).build();
        }
    }
}

