/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.frame;

import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.runtime.VmObjectLike;
import org.pkl.core.runtime.VmUtils;
import org.pkl.thirdparty.truffle.api.dsl.Specialization;
import org.pkl.thirdparty.truffle.api.frame.FrameSlotTypeException;
import org.pkl.thirdparty.truffle.api.frame.MaterializedFrame;
import org.pkl.thirdparty.truffle.api.frame.VirtualFrame;
import org.pkl.thirdparty.truffle.api.nodes.ExplodeLoop;
import org.pkl.thirdparty.truffle.api.source.SourceSection;

public abstract class ReadEnclosingFrameSlotNode
extends ExpressionNode {
    private final int slot;
    private final int levelsUp;

    protected ReadEnclosingFrameSlotNode(SourceSection sourceSection, int slot, int levelsUp) {
        super(sourceSection);
        this.slot = slot;
        this.levelsUp = levelsUp;
        assert (levelsUp > 0) : "should be using ReadFrameSlotNode for levelsUp == 0";
    }

    @Specialization(rewriteOn={FrameSlotTypeException.class})
    protected long evalInt(VirtualFrame frame) throws FrameSlotTypeException {
        return this.getCapturedFrame(frame).getLong(this.slot);
    }

    @Specialization(rewriteOn={FrameSlotTypeException.class})
    protected double evalFloat(VirtualFrame frame) throws FrameSlotTypeException {
        return this.getCapturedFrame(frame).getDouble(this.slot);
    }

    @Specialization(rewriteOn={FrameSlotTypeException.class})
    protected boolean evalBoolean(VirtualFrame frame) throws FrameSlotTypeException {
        return this.getCapturedFrame(frame).getBoolean(this.slot);
    }

    @Specialization(rewriteOn={FrameSlotTypeException.class})
    protected Object evalObject(VirtualFrame frame) throws FrameSlotTypeException {
        return this.getCapturedFrame(frame).getObject(this.slot);
    }

    @Specialization(replaces={"evalInt", "evalFloat", "evalBoolean", "evalObject"})
    protected Object evalGeneric(VirtualFrame frame) {
        return this.getCapturedFrame(frame).getValue(this.slot);
    }

    @ExplodeLoop
    protected final MaterializedFrame getCapturedFrame(VirtualFrame frame) {
        VmObjectLike owner = VmUtils.getOwner(frame);
        for (int i = 0; i < this.levelsUp - 1; ++i) {
            owner = owner.getEnclosingOwner();
            assert (owner != null);
        }
        return owner.getEnclosingFrame();
    }
}

