/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.member;

import java.util.LinkedHashMap;
import java.util.List;
import org.pkl.core.Member;
import org.pkl.core.PClass;
import org.pkl.core.PType;
import org.pkl.core.TypeParameter;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.VmModifier;
import org.pkl.core.ast.member.ClassMethod;
import org.pkl.core.ast.member.Lambda;
import org.pkl.core.ast.member.Member;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.ast.member.RegularMemberNode;
import org.pkl.core.ast.type.TypeNode;
import org.pkl.core.ast.type.VmTypeMismatchException;
import org.pkl.core.runtime.MirrorFactories;
import org.pkl.core.runtime.VmException;
import org.pkl.core.runtime.VmLanguage;
import org.pkl.core.runtime.VmMap;
import org.pkl.core.runtime.VmStackOverflowException;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.util.CollectionUtils;
import org.pkl.core.util.Nullable;
import org.pkl.core.util.Pair;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.frame.FrameDescriptor;
import org.pkl.thirdparty.truffle.api.frame.VirtualFrame;
import org.pkl.thirdparty.truffle.api.nodes.ExplodeLoop;
import org.pkl.thirdparty.truffle.api.nodes.Node;
import org.pkl.thirdparty.truffle.api.source.SourceSection;

public final class FunctionNode
extends RegularMemberNode {
    private static final int IMPLICIT_PARAM_COUNT = 3;
    private final int paramCount;
    private final int totalParamCount;
    @Node.Children
    private final TypeNode[] parameterTypeNodes;
    @Node.Child
    @Nullable
    private TypeNode checkedReturnTypeNode;
    @Nullable
    private TypeNode returnTypeNode;

    @CompilerDirectives.TruffleBoundary
    public FunctionNode(VmLanguage language, FrameDescriptor descriptor, Member member, int paramCount, TypeNode[] parameterTypeNodes, @Nullable TypeNode returnTypeNode, boolean isReturnTypeChecked, ExpressionNode bodyNode) {
        super(language, descriptor, member, bodyNode);
        assert (member instanceof ClassMethod || member instanceof ObjectMember || member instanceof Lambda);
        this.paramCount = paramCount;
        this.parameterTypeNodes = parameterTypeNodes;
        this.checkedReturnTypeNode = isReturnTypeChecked ? returnTypeNode : null;
        this.returnTypeNode = returnTypeNode;
        this.totalParamCount = Math.addExact(3, paramCount);
    }

    public int getParameterCount() {
        return this.paramCount;
    }

    @Nullable
    public TypeNode getReturnTypeNode() {
        return this.returnTypeNode;
    }

    @CompilerDirectives.TruffleBoundary
    public String getCallSignature() {
        StringBuilder sb = new StringBuilder(this.member.getName().toString());
        sb.append('(');
        for (int i = 0; i < Math.min(this.getFrameDescriptor().getNumberOfSlots(), this.paramCount); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.getFrameDescriptor().getSlotName(i));
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    @ExplodeLoop
    public Object execute(VirtualFrame frame) {
        int totalArgCount = frame.getArguments().length;
        if (totalArgCount != this.totalParamCount) {
            CompilerDirectives.transferToInterpreter();
            throw this.wrongArgumentCount(totalArgCount - 3);
        }
        boolean isInIterable = (Boolean)frame.getArguments()[2];
        try {
            for (int i = 0; i < this.parameterTypeNodes.length; ++i) {
                Object argument = frame.getArguments()[3 + i];
                if (isInIterable) {
                    this.parameterTypeNodes[i].executeEagerlyAndSet(frame, argument);
                    continue;
                }
                this.parameterTypeNodes[i].executeAndSet(frame, argument);
            }
            Object result = this.bodyNode.executeGeneric(frame);
            if (this.checkedReturnTypeNode != null) {
                return this.checkedReturnTypeNode.execute(frame, result);
            }
            return result;
        }
        catch (VmTypeMismatchException e2) {
            CompilerDirectives.transferToInterpreter();
            throw e2.toVmException();
        }
        catch (StackOverflowError e3) {
            CompilerDirectives.transferToInterpreter();
            throw new VmStackOverflowException(e3);
        }
        catch (Exception e4) {
            CompilerDirectives.transferToInterpreter();
            if (e4 instanceof VmException) {
                throw e4;
            }
            throw this.exceptionBuilder().bug(e4.getMessage(), new Object[0]).withCause(e4).build();
        }
    }

    public VmMap getParameterMirrors() {
        VmMap.Builder builder = VmMap.builder();
        for (int i = 0; i < this.paramCount; ++i) {
            String parameterName = this.getFrameDescriptor().getSlotName(i).toString();
            builder.add(parameterName, MirrorFactories.methodParameterFactory.create(Pair.of(parameterName, this.parameterTypeNodes[i].getMirror())));
        }
        return builder.build();
    }

    public VmTyped getReturnTypeMirror() {
        return TypeNode.getMirror(this.returnTypeNode);
    }

    public PClass.Method export(PClass owner, @Nullable SourceSection docComment, List<VmTyped> annotations, int modifiers, List<TypeParameter> typeParameters) {
        LinkedHashMap<String, PType> parameters = CollectionUtils.newLinkedHashMap(this.paramCount);
        for (int i = 0; i < this.paramCount; ++i) {
            Object slotName = this.getFrameDescriptor().getSlotName(i);
            Object paramName = slotName == null ? "_#" + i : slotName.toString();
            parameters.put((String)paramName, TypeNode.export(this.parameterTypeNodes[i]));
        }
        PClass.Method result = new PClass.Method(owner, VmUtils.exportDocComment(docComment), new Member.SourceLocation(this.getHeaderSection().getStartLine(), this.getSourceSection().getEndLine()), VmModifier.export(modifiers, false), VmUtils.exportAnnotations(annotations), this.member.getName().toString(), typeParameters, parameters, TypeNode.export(this.returnTypeNode));
        for (TypeParameter parameter : typeParameters) {
            parameter.initOwner(result);
        }
        return result;
    }

    private VmException wrongArgumentCount(int argCount) {
        assert (argCount != this.paramCount);
        return this.exceptionBuilder().evalError("wrongFunctionArgumentCount", this.paramCount, argCount).withSourceSection(this.member.getHeaderSection()).build();
    }
}

