/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.member;

import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.expression.primary.GetOwnerNode;
import org.pkl.core.ast.member.ClassProperty;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.ast.member.PropertyTypeNode;
import org.pkl.core.ast.member.RegularMemberNode;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmDynamic;
import org.pkl.core.runtime.VmLanguage;
import org.pkl.core.runtime.VmObjectLike;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.util.Nullable;
import org.pkl.thirdparty.truffle.api.dsl.Cached;
import org.pkl.thirdparty.truffle.api.dsl.Executed;
import org.pkl.thirdparty.truffle.api.dsl.Specialization;
import org.pkl.thirdparty.truffle.api.frame.FrameDescriptor;
import org.pkl.thirdparty.truffle.api.frame.VirtualFrame;
import org.pkl.thirdparty.truffle.api.nodes.DirectCallNode;
import org.pkl.thirdparty.truffle.api.nodes.IndirectCallNode;
import org.pkl.thirdparty.truffle.api.nodes.Node;

public abstract class TypeCheckedPropertyNode
extends RegularMemberNode {
    @Node.Child
    @Executed
    protected ExpressionNode ownerNode = new GetOwnerNode();

    protected TypeCheckedPropertyNode(@Nullable VmLanguage language, FrameDescriptor descriptor, ObjectMember member, ExpressionNode bodyNode) {
        super(language, descriptor, member, bodyNode);
        assert (member.isProp());
    }

    @Specialization(guards={"owner.getVmClass() == cachedOwnerClass"})
    protected Object evalTypedObjectCached(VirtualFrame frame, VmTyped owner, @Cached(value="owner.getVmClass()") VmClass cachedOwnerClass, @Cached(value="getProperty(cachedOwnerClass)") ClassProperty property, @Nullable @Cached(value="createTypeCheckCallNode(property)") DirectCallNode callNode) {
        Object result = this.executeBody(frame);
        if (callNode != null && VmUtils.shouldRunTypeCheck(frame)) {
            return callNode.call(VmUtils.getReceiverOrNull(frame), property.getOwner(), result, this.member.isInIterable());
        }
        return result;
    }

    @Specialization(guards={"!owner.isDynamic()"})
    protected Object eval(VirtualFrame frame, VmObjectLike owner, @Cached(value="create()") IndirectCallNode callNode) {
        ClassProperty property;
        PropertyTypeNode typeAnnNode;
        Object result = this.executeBody(frame);
        if (VmUtils.shouldRunTypeCheck(frame) && (typeAnnNode = (property = this.getProperty(owner.getVmClass())).getTypeNode()) != null) {
            return callNode.call(typeAnnNode.getCallTarget(), VmUtils.getReceiverOrNull(frame), property.getOwner(), result, this.member.isInIterable());
        }
        return result;
    }

    @Specialization
    protected Object eval(VirtualFrame frame, VmDynamic owner) {
        return this.executeBody(frame);
    }

    protected ClassProperty getProperty(VmClass ownerClass) {
        ClassProperty result = ownerClass.getProperty(this.member.getName());
        assert (result != null);
        return result;
    }

    @Nullable
    protected DirectCallNode createTypeCheckCallNode(ClassProperty property) {
        PropertyTypeNode typeCheckNode = property.getTypeNode();
        return typeCheckNode == null ? null : DirectCallNode.create(typeCheckNode.getCallTarget());
    }
}

