/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.evaluatorSettings;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.pkl.core.Duration;
import org.pkl.core.PNull;
import org.pkl.core.PObject;
import org.pkl.core.PklBugException;
import org.pkl.core.PklException;
import org.pkl.core.Value;
import org.pkl.core.evaluatorSettings.Color;
import org.pkl.core.util.ErrorMessages;
import org.pkl.core.util.Nullable;

public record PklEvaluatorSettings(@Nullable Map<String, String> externalProperties, @Nullable Map<String, String> env, @Nullable List<Pattern> allowedModules, @Nullable List<Pattern> allowedResources, @Nullable Color color, @Nullable Boolean noCache, @Nullable Path moduleCacheDir, @Nullable List<Path> modulePath, @Nullable Duration timeout, @Nullable Path rootDir, @Nullable Http http, @Nullable Map<String, ExternalReader> externalModuleReaders, @Nullable Map<String, ExternalReader> externalResourceReaders) {
    public static PklEvaluatorSettings parse(Value input, BiFunction<? super String, ? super String, Path> pathNormalizer) {
        if (!(input instanceof PObject)) {
            throw PklBugException.unreachableCode();
        }
        PObject pSettings = (PObject)input;
        String moduleCacheDirStr = (String)pSettings.get("moduleCacheDir");
        Path moduleCacheDir = moduleCacheDirStr == null ? null : pathNormalizer.apply(moduleCacheDirStr, "moduleCacheDir");
        List allowedModulesStrs = (List)pSettings.get("allowedModules");
        List<Pattern> allowedModules = allowedModulesStrs == null ? null : allowedModulesStrs.stream().map(Pattern::compile).toList();
        List allowedResourcesStrs = (List)pSettings.get("allowedResources");
        List<Pattern> allowedResources = allowedResourcesStrs == null ? null : allowedResourcesStrs.stream().map(Pattern::compile).toList();
        List modulePathStrs = (List)pSettings.get("modulePath");
        List<Path> modulePath = modulePathStrs == null ? null : modulePathStrs.stream().map(it -> (Path)pathNormalizer.apply((String)it, "modulePath")).toList();
        String rootDirStr = (String)pSettings.get("rootDir");
        Path rootDir = rootDirStr == null ? null : pathNormalizer.apply(rootDirStr, "rootDir");
        Map externalModuleReadersRaw = (Map)pSettings.get("externalModuleReaders");
        Map<String, ExternalReader> externalModuleReaders = externalModuleReadersRaw == null ? null : externalModuleReadersRaw.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ExternalReader.parse((Value)entry.getValue())));
        Map externalResourceReadersRaw = (Map)pSettings.get("externalResourceReaders");
        Map<String, ExternalReader> externalResourceReaders = externalResourceReadersRaw == null ? null : externalResourceReadersRaw.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ExternalReader.parse((Value)entry.getValue())));
        String color = (String)pSettings.get("color");
        return new PklEvaluatorSettings((Map)pSettings.get("externalProperties"), (Map)pSettings.get("env"), allowedModules, allowedResources, color == null ? null : Color.valueOf(color.toUpperCase()), (Boolean)pSettings.get("noCache"), moduleCacheDir, modulePath, (Duration)pSettings.get("timeout"), rootDir, Http.parse((Value)pSettings.get("http")), externalModuleReaders, externalResourceReaders);
    }

    private boolean arePatternsEqual(@Nullable List<Pattern> thesePatterns, @Nullable List<Pattern> thosePatterns) {
        if (thesePatterns == null) {
            return thosePatterns == null;
        }
        if (thosePatterns == null || thesePatterns.size() != thosePatterns.size()) {
            return false;
        }
        for (int i = 0; i < thesePatterns.size(); ++i) {
            if (thesePatterns.get(i).pattern().equals(thosePatterns.get(i).pattern())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PklEvaluatorSettings)) {
            return false;
        }
        PklEvaluatorSettings that = (PklEvaluatorSettings)obj;
        return Objects.equals(this.externalProperties, that.externalProperties) && Objects.equals(this.env, that.env) && this.arePatternsEqual(this.allowedModules, that.allowedModules) && this.arePatternsEqual(this.allowedResources, that.allowedResources) && Objects.equals((Object)this.color, (Object)that.color) && Objects.equals(this.noCache, that.noCache) && Objects.equals(this.moduleCacheDir, that.moduleCacheDir) && Objects.equals(this.timeout, that.timeout) && Objects.equals(this.rootDir, that.rootDir) && Objects.equals(this.http, that.http);
    }

    private int hashPatterns(@Nullable List<Pattern> patterns) {
        if (patterns == null) {
            return 0;
        }
        int ret = 1;
        for (Pattern pattern2 : patterns) {
            ret = 31 * ret + pattern2.pattern().hashCode();
        }
        return ret;
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(new Object[]{this.externalProperties, this.env, this.color, this.noCache, this.moduleCacheDir, this.timeout, this.rootDir, this.http});
        result = 31 * result + this.hashPatterns(this.allowedModules);
        result = 31 * result + this.hashPatterns(this.allowedResources);
        return result;
    }

    public record Http(@Nullable Proxy proxy) {
        public static final Http DEFAULT = new Http(null);

        @Nullable
        public static Http parse(@Nullable Value input) {
            if (input == null || input instanceof PNull) {
                return null;
            }
            if (input instanceof PObject) {
                PObject http = (PObject)input;
                Proxy proxy = Proxy.parse((Value)http.getProperty("proxy"));
                return proxy == null ? DEFAULT : new Http(proxy);
            }
            throw PklBugException.unreachableCode();
        }
    }

    public record ExternalReader(String executable, @Nullable List<String> arguments) {
        public static ExternalReader parse(Value input) {
            if (input instanceof PObject) {
                PObject externalReader = (PObject)input;
                String executable = (String)externalReader.getProperty("executable");
                List arguments = (List)externalReader.get("arguments");
                return new ExternalReader(executable, arguments);
            }
            throw PklBugException.unreachableCode();
        }
    }

    public record Proxy(@Nullable URI address, @Nullable List<String> noProxy) {
        public static Proxy create(@Nullable String address, @Nullable List<String> noProxy) {
            URI addressUri;
            try {
                addressUri = address == null ? null : new URI(address);
            }
            catch (URISyntaxException e2) {
                throw new PklException(ErrorMessages.create("invalidUri", address));
            }
            return new Proxy(addressUri, noProxy);
        }

        @Nullable
        public static Proxy parse(Value input) {
            if (input instanceof PNull) {
                return null;
            }
            if (input instanceof PObject) {
                PObject proxy = (PObject)input;
                String address = (String)proxy.get("address");
                List noProxy = (List)proxy.get("noProxy");
                return Proxy.create(address, noProxy);
            }
            throw PklBugException.unreachableCode();
        }
    }
}

