/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.externalreader;

import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.Map;
import org.pkl.core.externalreader.ExternalReaderMessages;
import org.pkl.core.messaging.BaseMessagePackDecoder;
import org.pkl.core.messaging.DecodeException;
import org.pkl.core.messaging.Message;
import org.pkl.core.util.Nullable;
import org.pkl.thirdparty.msgpack.core.MessagePack;
import org.pkl.thirdparty.msgpack.core.MessageUnpacker;
import org.pkl.thirdparty.msgpack.value.Value;

final class ExternalReaderMessagePackDecoder
extends BaseMessagePackDecoder {
    public ExternalReaderMessagePackDecoder(MessageUnpacker unpacker) {
        super(unpacker);
    }

    public ExternalReaderMessagePackDecoder(InputStream inputStream) {
        this(MessagePack.newDefaultUnpacker(inputStream));
    }

    @Override
    @Nullable
    protected Message decodeMessage(Message.Type msgType, Map<Value, Value> map2) throws DecodeException, URISyntaxException {
        return switch (msgType) {
            case Message.Type.INITIALIZE_MODULE_READER_REQUEST -> new ExternalReaderMessages.InitializeModuleReaderRequest(ExternalReaderMessagePackDecoder.unpackLong(map2, "requestId"), ExternalReaderMessagePackDecoder.unpackString(map2, "scheme"));
            case Message.Type.INITIALIZE_RESOURCE_READER_REQUEST -> new ExternalReaderMessages.InitializeResourceReaderRequest(ExternalReaderMessagePackDecoder.unpackLong(map2, "requestId"), ExternalReaderMessagePackDecoder.unpackString(map2, "scheme"));
            case Message.Type.INITIALIZE_MODULE_READER_RESPONSE -> new ExternalReaderMessages.InitializeModuleReaderResponse(ExternalReaderMessagePackDecoder.unpackLong(map2, "requestId"), ExternalReaderMessagePackDecoder.unpackModuleReaderSpec(ExternalReaderMessagePackDecoder.getNullable(map2, "spec")));
            case Message.Type.INITIALIZE_RESOURCE_READER_RESPONSE -> new ExternalReaderMessages.InitializeResourceReaderResponse(ExternalReaderMessagePackDecoder.unpackLong(map2, "requestId"), ExternalReaderMessagePackDecoder.unpackResourceReaderSpec(ExternalReaderMessagePackDecoder.getNullable(map2, "spec")));
            case Message.Type.CLOSE_EXTERNAL_PROCESS -> new ExternalReaderMessages.CloseExternalProcess();
            default -> super.decodeMessage(msgType, map2);
        };
    }
}

