/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.externalreader;

import java.io.IOException;
import java.io.OutputStream;
import org.pkl.core.externalreader.ExternalReaderMessages;
import org.pkl.core.messaging.BaseMessagePackEncoder;
import org.pkl.core.messaging.Message;
import org.pkl.core.messaging.ProtocolException;
import org.pkl.core.util.Nullable;
import org.pkl.thirdparty.msgpack.core.MessagePack;
import org.pkl.thirdparty.msgpack.core.MessagePacker;

final class ExternalReaderMessagePackEncoder
extends BaseMessagePackEncoder {
    public ExternalReaderMessagePackEncoder(MessagePacker packer) {
        super(packer);
    }

    public ExternalReaderMessagePackEncoder(OutputStream outputStream) {
        this(MessagePack.newDefaultPacker(outputStream));
    }

    @Override
    @Nullable
    protected void encodeMessage(Message msg) throws ProtocolException, IOException {
        switch (msg.type()) {
            case INITIALIZE_MODULE_READER_REQUEST: {
                ExternalReaderMessages.InitializeModuleReaderRequest m = (ExternalReaderMessages.InitializeModuleReaderRequest)msg;
                this.packer.packMapHeader(2);
                this.packKeyValue("requestId", m.requestId());
                this.packKeyValue("scheme", m.scheme());
                break;
            }
            case INITIALIZE_RESOURCE_READER_REQUEST: {
                ExternalReaderMessages.InitializeResourceReaderRequest m = (ExternalReaderMessages.InitializeResourceReaderRequest)msg;
                this.packer.packMapHeader(2);
                this.packKeyValue("requestId", m.requestId());
                this.packKeyValue("scheme", m.scheme());
                break;
            }
            case INITIALIZE_MODULE_READER_RESPONSE: {
                ExternalReaderMessages.InitializeModuleReaderResponse m = (ExternalReaderMessages.InitializeModuleReaderResponse)msg;
                this.packMapHeader(1, m.spec());
                this.packKeyValue("requestId", m.requestId());
                if (m.spec() == null) break;
                this.packer.packString("spec");
                this.packModuleReaderSpec(m.spec());
                break;
            }
            case INITIALIZE_RESOURCE_READER_RESPONSE: {
                ExternalReaderMessages.InitializeResourceReaderResponse m = (ExternalReaderMessages.InitializeResourceReaderResponse)msg;
                this.packMapHeader(1, m.spec());
                this.packKeyValue("requestId", m.requestId());
                if (m.spec() == null) break;
                this.packer.packString("spec");
                this.packResourceReaderSpec(m.spec());
                break;
            }
            case CLOSE_EXTERNAL_PROCESS: {
                this.packer.packMapHeader(0);
                break;
            }
            default: {
                super.encodeMessage(msg);
            }
        }
    }
}

