/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.messaging;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.pkl.core.messaging.DecodeException;
import org.pkl.core.messaging.Message;
import org.pkl.core.messaging.MessageDecoder;
import org.pkl.core.util.ErrorMessages;
import org.pkl.core.util.Nullable;
import org.pkl.thirdparty.msgpack.core.MessagePack;
import org.pkl.thirdparty.msgpack.core.MessageTypeException;
import org.pkl.thirdparty.msgpack.core.MessageUnpacker;
import org.pkl.thirdparty.msgpack.value.Value;
import org.pkl.thirdparty.msgpack.value.impl.ImmutableStringValueImpl;

public abstract class AbstractMessagePackDecoder
implements MessageDecoder {
    protected final MessageUnpacker unpacker;

    public AbstractMessagePackDecoder(MessageUnpacker unpacker) {
        this.unpacker = unpacker;
    }

    public AbstractMessagePackDecoder(InputStream stream) {
        this(MessagePack.newDefaultUnpacker(stream));
    }

    @Nullable
    protected abstract Message decodeMessage(Message.Type var1, Map<Value, Value> var2) throws DecodeException, URISyntaxException;

    @Override
    @Nullable
    public Message decode() throws IOException, DecodeException {
        Message.Type msgType;
        int code;
        if (!this.unpacker.hasNext()) {
            return null;
        }
        try {
            int arraySize = this.unpacker.unpackArrayHeader();
            if (arraySize != 2) {
                throw new DecodeException(ErrorMessages.create("malformedMessageHeaderLength", arraySize));
            }
            code = this.unpacker.unpackInt();
        }
        catch (MessageTypeException e2) {
            throw new DecodeException(ErrorMessages.create("malformedMessageHeaderException", new Object[0]), e2);
        }
        try {
            msgType = Message.Type.fromInt(code);
        }
        catch (IllegalArgumentException e3) {
            throw new DecodeException(ErrorMessages.create("malformedMessageHeaderUnrecognizedCode", Integer.toHexString(code)), e3);
        }
        try {
            Map<Value, Value> map2 = this.unpacker.unpackValue().asMapValue().map();
            Message decoded = this.decodeMessage(msgType, map2);
            if (decoded != null) {
                return decoded;
            }
            throw new DecodeException(ErrorMessages.create("unhandledMessageCode", Integer.toHexString(code)));
        }
        catch (URISyntaxException | MessageTypeException e4) {
            throw new DecodeException(ErrorMessages.create("malformedMessageBody", code), e4);
        }
    }

    @Nullable
    protected static Value getNullable(Map<Value, Value> map2, String key2) {
        return map2.get(new ImmutableStringValueImpl(key2));
    }

    protected static Value get(Map<Value, Value> map2, String key2) throws DecodeException {
        Value value2 = map2.get(new ImmutableStringValueImpl(key2));
        if (value2 == null) {
            throw new DecodeException(ErrorMessages.create("missingMessageParameter", key2));
        }
        return value2;
    }

    protected static String unpackString(Map<Value, Value> map2, String key2) throws DecodeException {
        return AbstractMessagePackDecoder.get(map2, key2).asStringValue().asString();
    }

    @Nullable
    protected static String unpackStringOrNull(Map<Value, Value> map2, String key2) {
        Value value2 = AbstractMessagePackDecoder.getNullable(map2, key2);
        if (value2 == null) {
            return null;
        }
        return value2.asStringValue().asString();
    }

    @Nullable
    protected static <T> T unpackStringOrNull(Map<Value, Value> map2, String key2, Function<String, T> mapper) {
        Value value2 = AbstractMessagePackDecoder.getNullable(map2, key2);
        if (value2 == null) {
            return null;
        }
        return mapper.apply(value2.asStringValue().asString());
    }

    protected static byte @Nullable [] unpackByteArray(Map<Value, Value> map2, String key2) {
        Value value2 = AbstractMessagePackDecoder.getNullable(map2, key2);
        if (value2 == null) {
            return null;
        }
        return value2.asBinaryValue().asByteArray();
    }

    protected static boolean unpackBoolean(Map<Value, Value> map2, String key2) throws DecodeException {
        return AbstractMessagePackDecoder.get(map2, key2).asBooleanValue().getBoolean();
    }

    protected static int unpackInt(Map<Value, Value> map2, String key2) throws DecodeException {
        return AbstractMessagePackDecoder.get(map2, key2).asIntegerValue().asInt();
    }

    protected static long unpackLong(Map<Value, Value> map2, String key2) throws DecodeException {
        return AbstractMessagePackDecoder.get(map2, key2).asIntegerValue().asLong();
    }

    @Nullable
    protected static Long unpackLongOrNull(Map<Value, Value> map2, String key2) {
        Value value2 = AbstractMessagePackDecoder.getNullable(map2, key2);
        if (value2 == null) {
            return null;
        }
        return value2.asIntegerValue().asLong();
    }

    @Nullable
    protected static <T> T unpackLongOrNull(Map<Value, Value> map2, String key2, Function<Long, T> mapper) {
        Long value2 = AbstractMessagePackDecoder.unpackLongOrNull(map2, key2);
        if (value2 == null) {
            return null;
        }
        return mapper.apply(value2);
    }

    @Nullable
    protected static List<String> unpackStringListOrNull(Map<Value, Value> map2, String key2) {
        Value value2 = AbstractMessagePackDecoder.getNullable(map2, key2);
        if (value2 == null) {
            return null;
        }
        return value2.asArrayValue().list().stream().map(it -> it.asStringValue().asString()).toList();
    }

    @Nullable
    protected static Map<String, String> unpackStringMapOrNull(Map<Value, Value> map2, String key2) {
        Value value2 = AbstractMessagePackDecoder.getNullable(map2, key2);
        if (value2 == null) {
            return null;
        }
        return value2.asMapValue().entrySet().stream().collect(Collectors.toMap(e2 -> ((Value)e2.getKey()).asStringValue().asString(), e2 -> ((Value)e2.getValue()).asStringValue().asString()));
    }

    @Nullable
    protected static <T> List<T> unpackStringListOrNull(Map<Value, Value> map2, String key2, Function<String, T> mapper) {
        List<String> value2 = AbstractMessagePackDecoder.unpackStringListOrNull(map2, key2);
        if (value2 == null) {
            return null;
        }
        return value2.stream().map(mapper).toList();
    }

    @Nullable
    protected static <T> List<T> unpackListOrNull(Map<Value, Value> map2, String key2, Function<Value, T> mapper) {
        Value keys2 = AbstractMessagePackDecoder.getNullable(map2, key2);
        if (keys2 == null) {
            return null;
        }
        ArrayList<T> result = new ArrayList<T>(keys2.asArrayValue().size());
        for (Value value2 : keys2.asArrayValue()) {
            result.add(mapper.apply(value2));
        }
        return result;
    }

    @Nullable
    protected static <T> Map<String, T> unpackStringMapOrNull(Map<Value, Value> map2, String key2, Function<Map<Value, Value>, T> mapper) {
        Value value2 = AbstractMessagePackDecoder.getNullable(map2, key2);
        if (value2 == null) {
            return null;
        }
        return value2.asMapValue().entrySet().stream().collect(Collectors.toMap(e2 -> ((Value)e2.getKey()).asStringValue().asString(), e2 -> mapper.apply(((Value)e2.getValue()).asMapValue().map())));
    }
}

