/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.messaging;

import java.io.IOException;
import java.io.OutputStream;
import org.pkl.core.messaging.AbstractMessagePackEncoder;
import org.pkl.core.messaging.Message;
import org.pkl.core.messaging.Messages;
import org.pkl.core.messaging.ProtocolException;
import org.pkl.core.module.PathElement;
import org.pkl.core.util.ErrorMessages;
import org.pkl.core.util.Nullable;
import org.pkl.thirdparty.msgpack.core.MessagePacker;

public class BaseMessagePackEncoder
extends AbstractMessagePackEncoder {
    public BaseMessagePackEncoder(MessagePacker packer) {
        super(packer);
    }

    public BaseMessagePackEncoder(OutputStream stream) {
        super(stream);
    }

    protected void packModuleReaderSpec(Messages.ModuleReaderSpec reader) throws IOException {
        this.packer.packMapHeader(4);
        this.packKeyValue("scheme", reader.scheme());
        this.packKeyValue("hasHierarchicalUris", reader.hasHierarchicalUris());
        this.packKeyValue("isLocal", reader.isLocal());
        this.packKeyValue("isGlobbable", reader.isGlobbable());
    }

    protected void packResourceReaderSpec(Messages.ResourceReaderSpec reader) throws IOException {
        this.packer.packMapHeader(3);
        this.packKeyValue("scheme", reader.scheme());
        this.packKeyValue("hasHierarchicalUris", reader.hasHierarchicalUris());
        this.packKeyValue("isGlobbable", reader.isGlobbable());
    }

    protected void packPathElement(PathElement pathElement) throws IOException {
        this.packer.packMapHeader(2);
        this.packKeyValue("name", pathElement.getName());
        this.packKeyValue("isDirectory", pathElement.isDirectory());
    }

    @Override
    @Nullable
    protected void encodeMessage(Message msg) throws ProtocolException, IOException {
        switch (msg.type()) {
            case READ_RESOURCE_REQUEST: {
                Messages.ReadResourceRequest m = (Messages.ReadResourceRequest)msg;
                this.packer.packMapHeader(3);
                this.packKeyValue("requestId", m.requestId());
                this.packKeyValue("evaluatorId", m.evaluatorId());
                this.packKeyValue("uri", m.uri().toString());
                break;
            }
            case READ_RESOURCE_RESPONSE: {
                Messages.ReadResourceResponse m = (Messages.ReadResourceResponse)msg;
                this.packMapHeader(2, m.contents(), m.error());
                this.packKeyValue("requestId", m.requestId());
                this.packKeyValue("evaluatorId", m.evaluatorId());
                this.packKeyValue("contents", m.contents());
                this.packKeyValue("error", m.error());
                break;
            }
            case READ_MODULE_REQUEST: {
                Messages.ReadModuleRequest m = (Messages.ReadModuleRequest)msg;
                this.packer.packMapHeader(3);
                this.packKeyValue("requestId", m.requestId());
                this.packKeyValue("evaluatorId", m.evaluatorId());
                this.packKeyValue("uri", m.uri().toString());
                break;
            }
            case READ_MODULE_RESPONSE: {
                Messages.ReadModuleResponse m = (Messages.ReadModuleResponse)msg;
                this.packMapHeader(2, m.contents(), m.error());
                this.packKeyValue("requestId", m.requestId());
                this.packKeyValue("evaluatorId", m.evaluatorId());
                this.packKeyValue("contents", m.contents());
                this.packKeyValue("error", m.error());
                break;
            }
            case LIST_RESOURCES_REQUEST: {
                Messages.ListResourcesRequest m = (Messages.ListResourcesRequest)msg;
                this.packer.packMapHeader(3);
                this.packKeyValue("requestId", m.requestId());
                this.packKeyValue("evaluatorId", m.evaluatorId());
                this.packKeyValue("uri", m.uri().toString());
                break;
            }
            case LIST_RESOURCES_RESPONSE: {
                Messages.ListResourcesResponse m = (Messages.ListResourcesResponse)msg;
                this.packMapHeader(2, m.pathElements(), m.error());
                this.packKeyValue("requestId", m.requestId());
                this.packKeyValue("evaluatorId", m.evaluatorId());
                if (m.pathElements() != null) {
                    this.packer.packString("pathElements");
                    this.packer.packArrayHeader(m.pathElements().size());
                    for (PathElement pathElement : m.pathElements()) {
                        this.packPathElement(pathElement);
                    }
                }
                this.packKeyValue("error", m.error());
                break;
            }
            case LIST_MODULES_REQUEST: {
                Messages.ListModulesRequest m = (Messages.ListModulesRequest)msg;
                this.packer.packMapHeader(3);
                this.packKeyValue("requestId", m.requestId());
                this.packKeyValue("evaluatorId", m.evaluatorId());
                this.packKeyValue("uri", m.uri().toString());
                break;
            }
            case LIST_MODULES_RESPONSE: {
                Messages.ListModulesResponse m = (Messages.ListModulesResponse)msg;
                this.packMapHeader(2, m.pathElements(), m.error());
                this.packKeyValue("requestId", m.requestId());
                this.packKeyValue("evaluatorId", m.evaluatorId());
                if (m.pathElements() != null) {
                    this.packer.packString("pathElements");
                    this.packer.packArrayHeader(m.pathElements().size());
                    for (PathElement pathElement : m.pathElements()) {
                        this.packPathElement(pathElement);
                    }
                }
                this.packKeyValue("error", m.error());
                break;
            }
            default: {
                throw new ProtocolException(ErrorMessages.create("unhandledMessageType", msg.type().toString()));
            }
        }
    }
}

