/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.messaging;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.pkl.core.messaging.Message;
import org.pkl.core.module.ExternalModuleResolver;
import org.pkl.core.module.PathElement;
import org.pkl.core.resource.ExternalResourceResolver;
import org.pkl.core.util.Nullable;

public final class Messages {
    private Messages() {
    }

    public record ReadModuleResponse(long requestId, long evaluatorId, @Nullable String contents, @Nullable String error) implements Message.Client.Response
    {
        @Override
        public Message.Type type() {
            return Message.Type.READ_MODULE_RESPONSE;
        }
    }

    public record ReadModuleRequest(long requestId, long evaluatorId, URI uri) implements Message.Request
    {
        @Override
        public Message.Type type() {
            return Message.Type.READ_MODULE_REQUEST;
        }
    }

    public record ReadResourceResponse(long requestId, long evaluatorId, byte @Nullable [] contents, @Nullable String error) implements Message.Client.Response
    {
        @Override
        public Message.Type type() {
            return Message.Type.READ_RESOURCE_RESPONSE;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ReadResourceResponse that = (ReadResourceResponse)o;
            return this.requestId == that.requestId && this.evaluatorId == that.evaluatorId && Objects.equals(this.error, that.error) && Arrays.equals(this.contents, that.contents);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.requestId, this.evaluatorId, Arrays.hashCode(this.contents), this.error);
        }
    }

    public record ReadResourceRequest(long requestId, long evaluatorId, URI uri) implements Message.Request
    {
        @Override
        public Message.Type type() {
            return Message.Type.READ_RESOURCE_REQUEST;
        }
    }

    public record ListModulesResponse(long requestId, long evaluatorId, @Nullable List<PathElement> pathElements, @Nullable String error) implements Message.Client.Response
    {
        @Override
        public Message.Type type() {
            return Message.Type.LIST_MODULES_RESPONSE;
        }
    }

    public record ListModulesRequest(long requestId, long evaluatorId, URI uri) implements Message.Server.Request
    {
        @Override
        public Message.Type type() {
            return Message.Type.LIST_MODULES_REQUEST;
        }
    }

    public record ListResourcesResponse(long requestId, long evaluatorId, @Nullable List<PathElement> pathElements, @Nullable String error) implements Message.Client.Response
    {
        @Override
        public Message.Type type() {
            return Message.Type.LIST_RESOURCES_RESPONSE;
        }
    }

    public record ListResourcesRequest(long requestId, long evaluatorId, URI uri) implements Message.Server.Request
    {
        @Override
        public Message.Type type() {
            return Message.Type.LIST_RESOURCES_REQUEST;
        }
    }

    public record ResourceReaderSpec(String scheme, boolean hasHierarchicalUris, boolean isGlobbable) implements ExternalResourceResolver.Spec
    {
    }

    public record ModuleReaderSpec(String scheme, boolean hasHierarchicalUris, boolean isLocal, boolean isGlobbable) implements ExternalModuleResolver.Spec
    {
    }
}

