/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.module;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.concurrent.GuardedBy;
import org.pkl.core.PklBugException;
import org.pkl.core.SecurityManager;
import org.pkl.core.SecurityManagerException;
import org.pkl.core.module.ModuleKey;
import org.pkl.core.packages.Dependency;
import org.pkl.core.packages.DependencyMetadata;
import org.pkl.core.packages.PackageLoadError;
import org.pkl.core.packages.PackageUri;
import org.pkl.core.project.CanonicalPackageUri;
import org.pkl.core.project.DeclaredDependencies;
import org.pkl.core.project.ProjectDeps;
import org.pkl.core.runtime.ModuleResolver;
import org.pkl.core.runtime.VmExceptionBuilder;
import org.pkl.core.util.EconomicMaps;
import org.pkl.core.util.IoUtils;
import org.pkl.core.util.json.Json;
import org.pkl.thirdparty.graalvm.collections.EconomicMap;

public final class ProjectDependenciesManager {
    public static final String PKL_PROJECT_FILENAME = "PklProject";
    public static final String PKL_PROJECT_DEPS_FILENAME = "PklProject.deps.json";
    private final DeclaredDependencies declaredDependencies;
    private final URI projectBaseUri;
    private final ModuleResolver moduleResolver;
    private final SecurityManager securityManager;
    @GuardedBy(value="lock")
    private ProjectDeps projectDeps;
    @GuardedBy(value="lock")
    private Map<String, Dependency> myDependencies = null;
    @GuardedBy(value="lock")
    private final EconomicMap<PackageUri, Map<String, Dependency>> localPackageDependencies = EconomicMaps.create();
    @GuardedBy(value="lock")
    private final EconomicMap<PackageUri, Map<String, Dependency>> packageDependencies = EconomicMaps.create();
    private final Object lock = new Object();

    public ProjectDependenciesManager(DeclaredDependencies declaredDependencies, ModuleResolver moduleResolver, SecurityManager securityManager) {
        this.declaredDependencies = declaredDependencies;
        this.projectBaseUri = IoUtils.resolve(declaredDependencies.getProjectFileUri(), ".");
        this.moduleResolver = moduleResolver;
        this.securityManager = securityManager;
    }

    public boolean hasUri(URI uri) {
        return this.projectBaseUri.getScheme().equals(uri.getScheme()) && Objects.equals(this.projectBaseUri.getAuthority(), uri.getAuthority()) && uri.getPath().startsWith(this.projectBaseUri.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureDependenciesInitialized() {
        Object object = this.lock;
        synchronized (object) {
            if (this.myDependencies != null) {
                return;
            }
            ProjectDeps projectDeps = this.getProjectDeps();
            this.myDependencies = this.doBuildResolvedDependenciesForProject(this.declaredDependencies, projectDeps);
            for (DeclaredDependencies localPkg : this.declaredDependencies.getLocalDependencies().values()) {
                this.ensureLocalProjectDependencyInitialized(localPkg, projectDeps);
            }
        }
    }

    private void ensureLocalProjectDependencyInitialized(DeclaredDependencies localProjectDependencies, ProjectDeps projectDeps) {
        PackageUri uri = PackageUri.create("project" + localProjectDependencies.getMyPackageUri());
        if (this.localPackageDependencies.containsKey(uri)) {
            return;
        }
        Map<String, Dependency> resolvedDeps = this.doBuildResolvedDependenciesForProject(localProjectDependencies, projectDeps);
        this.localPackageDependencies.put(uri, resolvedDeps);
        for (DeclaredDependencies declaredDeps : localProjectDependencies.getLocalDependencies().values()) {
            this.ensureLocalProjectDependencyInitialized(declaredDeps, projectDeps);
        }
    }

    private void checkProjectDependencyOutOfDate(URI projectFileUri, PackageUri declaredPackage, Dependency resolvedDependency) {
        if (resolvedDependency.getVersion().compareTo(declaredPackage.getVersion()) < 0) {
            throw new PackageLoadError("projectDependenciesOutOfDateInProject", projectFileUri, declaredPackage.getDisplayName(), resolvedDependency.getPackageUri().getDisplayName());
        }
    }

    private Map<String, Dependency> doBuildResolvedDependenciesForProject(DeclaredDependencies declaredDeps, ProjectDeps resolvedProjectDeps) {
        Object packageUri;
        HashMap<String, Dependency> ret = new HashMap<String, Dependency>(declaredDeps.getRemoteDependencies().size() + declaredDeps.getLocalDependencies().size());
        for (Map.Entry<String, DeclaredDependencies> entry : declaredDeps.getLocalDependencies().entrySet()) {
            DeclaredDependencies localDeclaredDependencies = entry.getValue();
            packageUri = localDeclaredDependencies.getMyPackageUri();
            assert (packageUri != null);
            CanonicalPackageUri canonicalPackageUri = CanonicalPackageUri.fromPackageUri(localDeclaredDependencies.getMyPackageUri());
            Dependency resolvedDep = resolvedProjectDeps.get(canonicalPackageUri);
            if (resolvedDep == null) {
                throw new PackageLoadError("unresolvedProjectDependency", packageUri);
            }
            this.checkProjectDependencyOutOfDate(declaredDeps.getProjectFileUri(), (PackageUri)packageUri, resolvedDep);
            ret.put(entry.getKey(), resolvedDep);
        }
        for (Map.Entry<String, Object> entry : declaredDeps.getRemoteDependencies().entrySet()) {
            Dependency.RemoteDependency remoteDep = (Dependency.RemoteDependency)entry.getValue();
            packageUri = CanonicalPackageUri.fromPackageUri(remoteDep.getPackageUri());
            Dependency resolvedDep = resolvedProjectDeps.get((CanonicalPackageUri)packageUri);
            if (resolvedDep == null) {
                throw new PackageLoadError("unresolvedProjectDependency", ((Dependency.RemoteDependency)entry.getValue()).getPackageUri());
            }
            this.checkProjectDependencyOutOfDate(declaredDeps.getProjectFileUri(), remoteDep.getPackageUri(), resolvedDep);
            ret.put(entry.getKey(), resolvedDep);
        }
        return ret;
    }

    public Map<String, Dependency> getDependencies() {
        this.ensureDependenciesInitialized();
        return this.myDependencies;
    }

    public boolean isLocalPackage(PackageUri packageUri) {
        this.ensureDependenciesInitialized();
        return this.localPackageDependencies.containsKey(packageUri);
    }

    public Map<String, Dependency> getLocalPackageDependencies(PackageUri packageUri) {
        this.ensureDependenciesInitialized();
        Map dep = (Map)this.localPackageDependencies.get(packageUri);
        assert (dep != null);
        return dep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Dependency> getResolvedDependenciesForPackage(PackageUri packageUri, DependencyMetadata dependencyMetadata) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.packageDependencies.containsKey(packageUri)) {
                Map<String, Dependency.RemoteDependency> declaredDependencies = dependencyMetadata.getDependencies();
                HashMap<String, Dependency> resolvedDeps = new HashMap<String, Dependency>(declaredDependencies.size());
                for (Map.Entry<String, Dependency.RemoteDependency> entry : declaredDependencies.entrySet()) {
                    Dependency.RemoteDependency packageDependency = entry.getValue();
                    CanonicalPackageUri canonicalPackage = CanonicalPackageUri.fromPackageUri(packageDependency.getPackageUri());
                    Dependency resolvedDep = this.projectDeps.get(canonicalPackage);
                    if (resolvedDep == null) {
                        throw new PackageLoadError("unresolvedProjectDependency", packageDependency);
                    }
                    if (resolvedDep.getVersion().compareTo(packageDependency.getVersion()) < 0) {
                        throw new PackageLoadError("projectDependenciesOutOfDateInPackage", packageUri.getDisplayName(), packageDependency.getPackageUri().getDisplayName(), resolvedDep.getPackageUri().getDisplayName());
                    }
                    resolvedDeps.put(entry.getKey(), resolvedDep);
                }
                this.packageDependencies.put(packageUri, resolvedDeps);
            }
            return (Map)this.packageDependencies.get(packageUri);
        }
    }

    public DeclaredDependencies getDeclaredDependencies() {
        return this.declaredDependencies;
    }

    public Dependency getResolvedDependency(PackageUri packageUri) {
        Dependency dep = this.getProjectDeps().get(CanonicalPackageUri.fromPackageUri(packageUri));
        if (dep == null) {
            throw new PackageLoadError("unresolvedProjectDependency", packageUri);
        }
        return dep;
    }

    public URI getProjectBaseUri() {
        return this.projectBaseUri;
    }

    public URI getProjectDepsFileUri() {
        return IoUtils.resolve(this.projectBaseUri, PKL_PROJECT_DEPS_FILENAME);
    }

    public URI getProjectFileUri() {
        return this.declaredDependencies.getProjectFileUri();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProjectDeps getProjectDeps() {
        Object object = this.lock;
        synchronized (object) {
            if (this.projectDeps == null) {
                URI depsUri = this.getProjectDepsFileUri();
                ModuleKey moduleKey = this.moduleResolver.resolve(depsUri);
                try {
                    String depsJson = moduleKey.resolve(this.securityManager).loadSource();
                    this.projectDeps = ProjectDeps.parse(depsJson);
                }
                catch (IOException e2) {
                    throw new VmExceptionBuilder().evalError("cannotLoadProjectDepsJson", depsUri).withCause(e2).withHint((String)(e2.getMessage() != null ? e2.getMessage() : "Encountered error: " + e2)).build();
                }
                catch (Json.JsonParseException e3) {
                    throw new VmExceptionBuilder().evalError("invalidProjectDepsJson", depsUri, e3.getMessage()).build();
                }
                catch (SecurityManagerException e4) {
                    throw PklBugException.unreachableCode();
                }
            }
            return this.projectDeps;
        }
    }
}

