/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.project;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import org.pkl.core.PklBugException;
import org.pkl.core.packages.PackageUri;
import org.pkl.core.util.ErrorMessages;

public final class CanonicalPackageUri {
    private final URI baseUri;
    private final int majorVersion;

    public static CanonicalPackageUri fromPackageUri(PackageUri packageUri) {
        URI baseUri;
        URI uri = packageUri.getUri();
        try {
            baseUri = new URI("package", null, uri.getHost(), uri.getPort(), packageUri.getPathWithoutVersion(), null, null);
        }
        catch (URISyntaxException e2) {
            throw PklBugException.unreachableCode();
        }
        return new CanonicalPackageUri(baseUri, packageUri.getVersion().getMajor());
    }

    public static CanonicalPackageUri of(String uriStr) throws URISyntaxException {
        int majorVersion;
        int versionIdx = uriStr.lastIndexOf(64);
        if (versionIdx == -1) {
            throw new URISyntaxException(uriStr, ErrorMessages.create("missingVersionInPackageUri", uriStr));
        }
        try {
            majorVersion = Integer.parseInt(uriStr.substring(versionIdx + 1));
        }
        catch (NumberFormatException e2) {
            throw new URISyntaxException(uriStr, ErrorMessages.create("", new Object[0]));
        }
        URI baseUri = new URI(uriStr.substring(0, versionIdx));
        return new CanonicalPackageUri(baseUri, majorVersion);
    }

    public CanonicalPackageUri(URI baseUri, int majorVersion) {
        this.baseUri = baseUri;
        this.majorVersion = majorVersion;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public URI getBaseUri() {
        return this.baseUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CanonicalPackageUri that = (CanonicalPackageUri)o;
        return this.majorVersion == that.majorVersion && this.baseUri.equals(that.baseUri);
    }

    public int hashCode() {
        return Objects.hash(this.baseUri, this.majorVersion);
    }

    public String toString() {
        return this.baseUri + "@" + this.majorVersion;
    }
}

