/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.project;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.pkl.core.Analyzer;
import org.pkl.core.Composite;
import org.pkl.core.Duration;
import org.pkl.core.Evaluator;
import org.pkl.core.EvaluatorBuilder;
import org.pkl.core.ImportGraph;
import org.pkl.core.ModuleSource;
import org.pkl.core.PClassInfo;
import org.pkl.core.PNull;
import org.pkl.core.PObject;
import org.pkl.core.PklException;
import org.pkl.core.SecurityManager;
import org.pkl.core.SecurityManagers;
import org.pkl.core.StackFrameTransformer;
import org.pkl.core.StackFrameTransformers;
import org.pkl.core.Value;
import org.pkl.core.Version;
import org.pkl.core.evaluatorSettings.PklEvaluatorSettings;
import org.pkl.core.module.ModuleKeyFactories;
import org.pkl.core.packages.Checksums;
import org.pkl.core.packages.Dependency;
import org.pkl.core.packages.PackageLoadError;
import org.pkl.core.packages.PackageUri;
import org.pkl.core.packages.PackageUtils;
import org.pkl.core.project.DeclaredDependencies;
import org.pkl.core.project.Package;
import org.pkl.core.resource.ResourceReaders;
import org.pkl.core.runtime.VmException;
import org.pkl.core.runtime.VmExceptionBuilder;
import org.pkl.core.util.ImportGraphUtils;
import org.pkl.core.util.IoUtils;
import org.pkl.core.util.Nullable;

public final class Project {
    @Nullable
    private final Package pkg;
    private final DeclaredDependencies dependencies;
    private final PklEvaluatorSettings evaluatorSettings;
    private final URI projectFileUri;
    private final URI projectBaseUri;
    private final List<URI> tests;
    private final Map<String, Project> localProjectDependencies;
    private final List<PObject> annotations;

    public static Project loadFromPath(Path path, SecurityManager securityManager, @Nullable java.time.Duration timeout, StackFrameTransformer stackFrameTransformer, Map<String, String> envVars) {
        try (Evaluator evaluator = EvaluatorBuilder.unconfigured().setSecurityManager(securityManager).setStackFrameTransformer(stackFrameTransformer).addModuleKeyFactory(ModuleKeyFactories.standardLibrary).addModuleKeyFactory(ModuleKeyFactories.file).addResourceReader(ResourceReaders.environmentVariable()).addResourceReader(ResourceReaders.file()).addEnvironmentVariables(envVars).setTimeout(timeout).build();){
            Project project = Project.load(evaluator, ModuleSource.path(path));
            return project;
        }
    }

    public static Project loadFromPath(Path path, SecurityManager securityManager, @Nullable java.time.Duration timeout) {
        return Project.loadFromPath(path, securityManager, timeout, StackFrameTransformers.defaultTransformer, System.getenv());
    }

    public static Project loadFromPath(Path path) {
        return Project.loadFromPath(path, SecurityManagers.defaultManager, null);
    }

    public static Project load(ModuleSource moduleSource) {
        try (Evaluator evaluator = Project.evaluatorBuilder().build();){
            Project project = Project.load(evaluator, moduleSource);
            return project;
        }
    }

    public static Project load(Evaluator evaluator, ModuleSource moduleSource) {
        try {
            PObject output = evaluator.evaluateOutputValueAs(moduleSource, PClassInfo.Project);
            return Project.parseProject(output);
        }
        catch (StackOverflowError e2) {
            List<List<URI>> cycles = Project.findImportCycle(moduleSource);
            if (!cycles.isEmpty()) {
                VmException vmException;
                if (cycles.size() == 1) {
                    vmException = new VmExceptionBuilder().evalError("cannotHaveCircularProjectDependenciesSingle", Project.renderCycle((List)cycles.stream().toList().get(0))).withCause(e2).build();
                } else {
                    String renderedCycles = Project.renderMultipleCycles(cycles);
                    vmException = new VmExceptionBuilder().evalError("cannotHaveCircularProjectDependenciesMultiple", renderedCycles).withCause(e2).build();
                }
                throw vmException.toPklException(StackFrameTransformers.defaultTransformer, false);
            }
            throw e2;
        }
        catch (URISyntaxException e3) {
            throw new PklException(e3.getMessage(), e3);
        }
    }

    private static String renderMultipleCycles(List<List<URI>> cycles) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (List<URI> cycle : cycles) {
            if (i > 0) {
                sb.append('\n');
            }
            sb.append("Cycle ").append(i + 1).append(":\n");
            Project.renderCycle(sb, cycle);
            sb.append('\n');
            ++i;
        }
        return sb.toString();
    }

    private static void renderCycle(StringBuilder sb, List<URI> cycle) {
        sb.append("\u250c\u2500>");
        boolean isFirst = true;
        for (URI uri : cycle) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append("\n\u2502");
            }
            sb.append("\n\u2502  ");
            sb.append(uri.toString());
        }
        sb.append("\n\u2514\u2500");
    }

    private static String renderCycle(List<URI> cycle) {
        StringBuilder sb = new StringBuilder();
        Project.renderCycle(sb, cycle);
        return sb.toString();
    }

    private static List<List<URI>> findImportCycle(ModuleSource moduleSource) {
        EvaluatorBuilder builder = Project.evaluatorBuilder();
        Analyzer analyzer = new Analyzer(StackFrameTransformers.defaultTransformer, builder.getColor(), SecurityManagers.defaultManager, builder.getModuleKeyFactories(), builder.getModuleCacheDir(), builder.getProjectDependencies(), builder.getHttpClient());
        ImportGraph importGraph2 = analyzer.importGraph(moduleSource.getUri());
        List<List<URI>> ret = ImportGraphUtils.findImportCycles(importGraph2);
        return ret.stream().filter(cycle -> cycle.stream().anyMatch(uri -> uri.getScheme().equalsIgnoreCase(moduleSource.getUri().getScheme()))).collect(Collectors.toList());
    }

    private static EvaluatorBuilder evaluatorBuilder() {
        return EvaluatorBuilder.unconfigured().setSecurityManager(SecurityManagers.defaultManager).setStackFrameTransformer(StackFrameTransformers.defaultTransformer).addModuleKeyFactory(ModuleKeyFactories.standardLibrary).addModuleKeyFactory(ModuleKeyFactories.file).addModuleKeyFactory(ModuleKeyFactories.classPath(Project.class.getClassLoader())).addResourceReader(ResourceReaders.environmentVariable()).addResourceReader(ResourceReaders.file());
    }

    private static DeclaredDependencies parseDependencies(PObject module, URI projectFileUri, @Nullable PackageUri packageUri) throws URISyntaxException {
        HashMap<String, Dependency.RemoteDependency> remoteDependencies = new HashMap<String, Dependency.RemoteDependency>();
        HashMap<String, DeclaredDependencies> localDependencies = new HashMap<String, DeclaredDependencies>();
        Map dependencies = (Map)module.getProperty("dependencies");
        for (Map.Entry entry : dependencies.entrySet()) {
            PObject value2 = (PObject)entry.getValue();
            if (value2.getClassInfo().equals(PClassInfo.Project)) {
                URI localProjectFileUri = URI.create((String)value2.getProperty("projectFileUri"));
                PackageUri localPkgUri = PackageUri.create((String)((PObject)value2.getProperty("package")).getProperty("uri"));
                localDependencies.put((String)entry.getKey(), Project.parseDependencies(value2, localProjectFileUri, localPkgUri));
                continue;
            }
            remoteDependencies.put((String)entry.getKey(), Project.parseRemoteDependency(value2));
        }
        return new DeclaredDependencies(remoteDependencies, localDependencies, projectFileUri, packageUri);
    }

    private static Dependency.RemoteDependency parseRemoteDependency(PObject object) throws URISyntaxException {
        PackageUri packageUri = new PackageUri((String)object.getProperty("uri"));
        PackageUtils.checkHasNoChecksumComponent(packageUri);
        Object objChecksum = object.getProperty("checksums");
        Checksums checksums = null;
        if (objChecksum instanceof PObject) {
            PObject pObject = (PObject)objChecksum;
            String sha2562 = (String)pObject.get("sha256");
            assert (sha2562 != null);
            checksums = new Checksums(sha2562);
        }
        return new Dependency.RemoteDependency(packageUri, checksums);
    }

    private static List<PObject> parseAnnotations(PObject module) {
        return (List)Project.getProperty(module, "annotations");
    }

    public static Project parseProject(PObject module) throws URISyntaxException {
        Object pkgObj = Project.getNullableProperty(module, "package");
        URI projectFileUri = URI.create((String)module.getProperty("projectFileUri"));
        DeclaredDependencies dependencies = Project.parseDependencies(module, projectFileUri, null);
        URI projectBaseUri = IoUtils.resolve(projectFileUri, ".");
        Package pkg = null;
        if (pkgObj != null) {
            pkg = Project.parsePackage((PObject)pkgObj);
        }
        PklEvaluatorSettings evaluatorSettings = Project.getProperty(module, "evaluatorSettings", settings -> PklEvaluatorSettings.parse((Value)settings, (it, name) -> Project.resolveNullablePath(it, projectBaseUri, name)));
        List testPathStrs = (List)Project.getProperty(module, "tests");
        List<URI> tests = testPathStrs.stream().map(it -> projectBaseUri.resolve((String)it).normalize()).collect(Collectors.toList());
        Map<String, Project> localProjectDependencies = Project.parseLocalProjectDependencies(module);
        List<PObject> annotations = Project.parseAnnotations(module);
        return new Project(pkg, dependencies, evaluatorSettings, projectFileUri, projectBaseUri, tests, localProjectDependencies, annotations);
    }

    private static Map<String, Project> parseLocalProjectDependencies(PObject module) throws URISyntaxException {
        Map dependencies = (Map)module.getProperty("dependencies");
        HashMap<String, Project> result = new HashMap<String, Project>();
        for (Map.Entry entry : dependencies.entrySet()) {
            PObject value2 = (PObject)entry.getValue();
            if (!value2.getClassInfo().equals(PClassInfo.Project)) continue;
            result.put((String)entry.getKey(), Project.parseProject((PObject)entry.getValue()));
        }
        return result;
    }

    private static Object getProperty(PObject settings, String propertyName) {
        return settings.getProperty(propertyName);
    }

    private static <T> T getProperty(PObject settings, String propertyName, Function<Object, T> f) {
        return Objects.requireNonNull(Project.getNullableProperty(settings, propertyName, f));
    }

    @Nullable
    private static Object getNullableProperty(Composite object, String propertyName) {
        Object result = object.getPropertyOrNull(propertyName);
        if (result instanceof PNull || result == null) {
            return null;
        }
        return result;
    }

    @Nullable
    private static <T> T getNullableProperty(Composite object, String propertyName, Function<Object, T> f) {
        Object value2 = object.getPropertyOrNull(propertyName);
        if (value2 instanceof PNull || value2 == null) {
            return null;
        }
        return f.apply(value2);
    }

    @Nullable
    private static URI getNullableURI(Composite object, String propertyName) throws URISyntaxException {
        Object value2 = object.getPropertyOrNull(propertyName);
        if (value2 instanceof PNull || value2 == null) {
            return null;
        }
        return new URI((String)value2);
    }

    @Nullable
    private static Path resolveNullablePath(@Nullable String path, URI projectBaseUri, String propertyName) {
        if (path == null) {
            return null;
        }
        try {
            return Path.of(projectBaseUri).resolve(path).normalize();
        }
        catch (FileSystemNotFoundException e2) {
            throw new PackageLoadError("relativePathPropertyDefinedByProjectFromNonFileUri", projectBaseUri, propertyName);
        }
    }

    private static Package parsePackage(PObject pObj) throws URISyntaxException {
        String name = (String)pObj.getProperty("name");
        PackageUri uri = new PackageUri((String)pObj.getProperty("uri"));
        Version version = Version.parse((String)Project.getProperty(pObj, "version"));
        URI packageZipUrl = new URI((String)Project.getProperty(pObj, "packageZipUrl"));
        String description = (String)Project.getNullableProperty(pObj, "description");
        List authors = (List)Project.getProperty(pObj, "authors");
        URI website = Project.getNullableURI(pObj, "website");
        URI documentation = Project.getNullableURI(pObj, "documentation");
        URI sourceCode = Project.getNullableURI(pObj, "sourceCode");
        String sourceCodeUrlScheme = (String)Project.getNullableProperty(pObj, "sourceCodeUrlScheme");
        String license = (String)Project.getNullableProperty(pObj, "license");
        String licenseText = (String)Project.getNullableProperty(pObj, "licenseText");
        URI issueTracker = Project.getNullableURI(pObj, "issueTracker");
        List apiTestStrs = (List)Project.getProperty(pObj, "apiTests");
        List<Path> apiTests = apiTestStrs.stream().map(x$0 -> Path.of(x$0, new String[0])).collect(Collectors.toList());
        List exclude = (List)Project.getProperty(pObj, "exclude");
        return new Package(name, uri, version, packageZipUrl, description, authors, website, documentation, sourceCode, sourceCodeUrlScheme, license, licenseText, issueTracker, apiTests, exclude);
    }

    private Project(@Nullable Package pkg, DeclaredDependencies dependencies, PklEvaluatorSettings evaluatorSettings, URI projectFileUri, URI projectBaseUri, List<URI> tests, Map<String, Project> localProjectDependencies, List<PObject> annotations) {
        this.pkg = pkg;
        this.dependencies = dependencies;
        this.evaluatorSettings = evaluatorSettings;
        this.projectFileUri = projectFileUri;
        this.projectBaseUri = projectBaseUri;
        this.tests = tests;
        this.localProjectDependencies = localProjectDependencies;
        this.annotations = annotations;
    }

    @Nullable
    public Package getPackage() {
        return this.pkg;
    }

    @Deprecated(forRemoval=true)
    public EvaluatorSettings getSettings() {
        return new EvaluatorSettings(this.evaluatorSettings);
    }

    public PklEvaluatorSettings getEvaluatorSettings() {
        return this.evaluatorSettings;
    }

    public URI getProjectFileUri() {
        return this.projectFileUri;
    }

    public List<Path> getTests() {
        return this.tests.stream().map(it -> {
            try {
                return Path.of(it);
            }
            catch (FileSystemNotFoundException e2) {
                throw new PackageLoadError("invalidUsageOfProjectFromNonFileUri", new Object[0]);
            }
        }).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Project project = (Project)o;
        return Objects.equals(this.pkg, project.pkg) && this.dependencies.equals(project.dependencies) && this.evaluatorSettings.equals(project.evaluatorSettings) && this.projectFileUri.equals(project.projectFileUri) && this.tests.equals(project.tests) && this.annotations.equals(project.annotations);
    }

    public int hashCode() {
        return Objects.hash(this.pkg, this.dependencies, this.evaluatorSettings, this.projectFileUri, this.tests, this.annotations);
    }

    public DeclaredDependencies getDependencies() {
        return this.dependencies;
    }

    public Map<String, Project> getLocalProjectDependencies() {
        return this.localProjectDependencies;
    }

    public URI getProjectBaseUri() {
        return this.projectBaseUri;
    }

    public Path getProjectDir() {
        assert (this.projectBaseUri.getScheme().equalsIgnoreCase("file"));
        return Path.of(this.projectBaseUri);
    }

    public List<PObject> getAnnotations() {
        return this.annotations;
    }

    @Deprecated(forRemoval=true)
    public static class EvaluatorSettings {
        private final PklEvaluatorSettings delegate;

        public EvaluatorSettings(PklEvaluatorSettings delegate) {
            this.delegate = delegate;
        }

        public EvaluatorSettings(@Nullable Map<String, String> externalProperties, @Nullable Map<String, String> env, @Nullable List<Pattern> allowedModules, @Nullable List<Pattern> allowedResources, @Nullable Boolean noCache, @Nullable Path moduleCacheDir, @Nullable List<Path> modulePath, @Nullable Duration timeout, @Nullable Path rootDir) {
            this.delegate = new PklEvaluatorSettings(externalProperties, env, allowedModules, allowedResources, null, noCache, moduleCacheDir, modulePath, timeout, rootDir, null, null, null);
        }

        @Deprecated(forRemoval=true)
        @Nullable
        public Map<String, String> getExternalProperties() {
            return this.delegate.externalProperties();
        }

        @Deprecated(forRemoval=true)
        @Nullable
        public Map<String, String> getEnv() {
            return this.delegate.env();
        }

        @Deprecated(forRemoval=true)
        @Nullable
        public List<Pattern> getAllowedModules() {
            return this.delegate.allowedModules();
        }

        @Deprecated(forRemoval=true)
        @Nullable
        public List<Pattern> getAllowedResources() {
            return this.delegate.allowedResources();
        }

        @Deprecated(forRemoval=true)
        @Nullable
        public Boolean isNoCache() {
            return this.delegate.noCache();
        }

        @Deprecated(forRemoval=true)
        @Nullable
        public List<Path> getModulePath() {
            return this.delegate.modulePath();
        }

        @Deprecated(forRemoval=true)
        @Nullable
        public Duration getTimeout() {
            return this.delegate.timeout();
        }

        @Deprecated(forRemoval=true)
        @Nullable
        public Path getModuleCacheDir() {
            return this.delegate.moduleCacheDir();
        }

        @Deprecated(forRemoval=true)
        @Nullable
        public Path getRootDir() {
            return this.delegate.rootDir();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass() && Objects.equals(this.delegate, ((EvaluatorSettings)o).delegate);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public String toString() {
            return "EvaluatorSettings{externalProperties=" + this.delegate.externalProperties() + ", env=" + this.delegate.env() + ", allowedModules=" + this.delegate.allowedModules() + ", allowedResources=" + this.delegate.allowedResources() + ", noCache=" + this.delegate.noCache() + ", moduleCacheDir=" + this.delegate.moduleCacheDir() + ", modulePath=" + this.delegate.modulePath() + ", timeout=" + this.delegate.timeout() + ", rootDir=" + this.delegate.rootDir() + "}";
        }
    }
}

