/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.runtime;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Optional;
import org.pkl.core.ModuleSource;
import org.pkl.core.externalreader.ExternalReaderProcessException;
import org.pkl.core.module.ModuleKey;
import org.pkl.core.module.ModuleKeyFactory;
import org.pkl.core.module.ModuleKeys;
import org.pkl.core.runtime.VmExceptionBuilder;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.util.Nullable;
import org.pkl.thirdparty.truffle.api.nodes.Node;

public final class ModuleResolver {
    private final Collection<ModuleKeyFactory> factories;

    public ModuleResolver(Collection<ModuleKeyFactory> factories) {
        this.factories = factories;
    }

    public Collection<ModuleKeyFactory> getFactories() {
        return this.factories;
    }

    public ModuleKey resolve(ModuleSource moduleSource) {
        if (!moduleSource.getUri().isAbsolute()) {
            throw new VmExceptionBuilder().evalError("cannotEvaluateRelativeModuleUri", moduleSource.getUri()).build();
        }
        if (moduleSource.getContents() != null) {
            if (moduleSource.getUri().equals(VmUtils.REPL_TEXT_URI)) {
                return ModuleKeys.synthetic(moduleSource.getUri(), moduleSource.getContents());
            }
            return this.resolveCached(moduleSource.getUri(), moduleSource.getContents());
        }
        return this.resolve(moduleSource.getUri());
    }

    public ModuleKey resolve(URI moduleUri) {
        return this.resolve(moduleUri, null);
    }

    public ModuleKey resolveCached(URI moduleUri, String text) {
        ModuleKey underlyingModuleKey = this.resolve(moduleUri);
        return ModuleKeys.cached(underlyingModuleKey, text);
    }

    public ModuleKey resolve(URI moduleUri, @Nullable Node importNode) {
        if (!moduleUri.isAbsolute()) {
            throw new VmExceptionBuilder().withOptionalLocation(importNode).bug("Cannot resolve relative URI `%s`.", moduleUri).build();
        }
        URI normalized = moduleUri.normalize();
        for (ModuleKeyFactory factory : this.factories) {
            Optional<ModuleKey> key2;
            try {
                key2 = factory.create(normalized);
            }
            catch (URISyntaxException e2) {
                throw new VmExceptionBuilder().withOptionalLocation(importNode).evalError("invalidModuleUri", moduleUri).withHint(e2.getReason()).build();
            }
            catch (ExternalReaderProcessException e3) {
                throw new VmExceptionBuilder().withOptionalLocation(importNode).evalError("externalReaderFailure", new Object[0]).withCause(e3).build();
            }
            catch (IOException e4) {
                throw new VmExceptionBuilder().withOptionalLocation(importNode).evalError("ioErrorLoadingModule", new Object[0]).withCause(e4).build();
            }
            if (!key2.isPresent()) continue;
            return key2.get();
        }
        throw new VmExceptionBuilder().evalError("noModuleLoaderRegistered", moduleUri).withOptionalLocation(importNode).build();
    }
}

