/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.runtime;

import java.net.URI;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.StdLibModule;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;

public final class PlatformModule
extends StdLibModule {
    private static final VmTyped instance = VmUtils.createEmptyModule();

    public static VmTyped getModule() {
        return instance;
    }

    public static VmClass getPlatformClass() {
        return PlatformClass.instance;
    }

    public static VmClass getLanguageClass() {
        return LanguageClass.instance;
    }

    public static VmClass getRuntimeClass() {
        return RuntimeClass.instance;
    }

    public static VmClass getVirtualMachineClass() {
        return VirtualMachineClass.instance;
    }

    public static VmClass getOperatingSystemClass() {
        return OperatingSystemClass.instance;
    }

    public static VmClass getProcessorClass() {
        return ProcessorClass.instance;
    }

    @CompilerDirectives.TruffleBoundary
    private static VmClass loadClass(String className) {
        VmTyped theModule = PlatformModule.getModule();
        return (VmClass)VmUtils.readMember(theModule, Identifier.get(className));
    }

    static {
        PlatformModule.loadModule(URI.create("pkl:platform"), instance);
    }

    private static final class PlatformClass {
        static final VmClass instance = PlatformModule.loadClass("Platform");

        private PlatformClass() {
        }
    }

    private static final class LanguageClass {
        static final VmClass instance = PlatformModule.loadClass("Language");

        private LanguageClass() {
        }
    }

    private static final class RuntimeClass {
        static final VmClass instance = PlatformModule.loadClass("Runtime");

        private RuntimeClass() {
        }
    }

    private static final class VirtualMachineClass {
        static final VmClass instance = PlatformModule.loadClass("VirtualMachine");

        private VirtualMachineClass() {
        }
    }

    private static final class OperatingSystemClass {
        static final VmClass instance = PlatformModule.loadClass("OperatingSystem");

        private OperatingSystemClass() {
        }
    }

    private static final class ProcessorClass {
        static final VmClass instance = PlatformModule.loadClass("Processor");

        private ProcessorClass() {
        }
    }
}

