/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.runtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.pkl.core.StackFrame;
import org.pkl.core.ast.MemberNode;
import org.pkl.core.runtime.VmException;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.util.Nullable;
import org.pkl.thirdparty.truffle.api.CallTarget;
import org.pkl.thirdparty.truffle.api.RootCallTarget;
import org.pkl.thirdparty.truffle.api.TruffleStackTrace;
import org.pkl.thirdparty.truffle.api.TruffleStackTraceElement;
import org.pkl.thirdparty.truffle.api.nodes.Node;
import org.pkl.thirdparty.truffle.api.nodes.RootNode;
import org.pkl.thirdparty.truffle.api.source.SourceSection;

final class StackTraceGenerator {
    private final VmException exception;
    private final List<StackFrame> frames = new ArrayList<StackFrame>();

    static List<StackFrame> capture(VmException exception) {
        return new StackTraceGenerator(exception).capture();
    }

    private StackTraceGenerator(VmException exception) {
        this.exception = exception;
    }

    private List<StackFrame> capture() {
        List<TruffleStackTraceElement> truffleElements = TruffleStackTrace.getStackTrace(this.exception);
        if (truffleElements.isEmpty()) {
            this.addFrame(this.exception.getSourceSection(), this.exception.getMemberName());
        } else {
            boolean isFirst = true;
            HashMap<CallTarget, StackFrame> insertedStackFrames = new HashMap<CallTarget, StackFrame>(this.exception.getInsertedStackFrames());
            for (TruffleStackTraceElement element : truffleElements) {
                Node callNode = element.getLocation();
                this.addFrame(this.findDisplayableSourceSection(callNode, isFirst), this.getMemberName(element));
                isFirst = false;
                RootCallTarget callTarget = element.getTarget();
                StackFrame insertedFrame = insertedStackFrames.remove(callTarget);
                if (insertedFrame == null) continue;
                this.frames.add(insertedFrame);
            }
        }
        return this.frames;
    }

    private SourceSection findDisplayableSourceSection(@Nullable Node callNode, boolean isFirst) {
        if (isFirst && this.exception.getSourceSection() != null) {
            return this.exception.getSourceSection();
        }
        for (Node current2 = callNode; current2 != null; current2 = current2.getParent()) {
            SourceSection sourceSection;
            if (current2.getSourceSection() == null) continue;
            if (current2 instanceof MemberNode) {
                MemberNode memberNode = (MemberNode)current2;
                sourceSection = memberNode.getBodySection();
            } else {
                sourceSection = current2.getSourceSection();
            }
            return sourceSection;
        }
        return VmUtils.unavailableSourceSection();
    }

    private void addFrame(@Nullable SourceSection section, @Nullable String memberName) {
        if (section == null || !section.isAvailable()) {
            return;
        }
        this.frames.add(VmUtils.createStackFrame(section, memberName));
    }

    @Nullable
    private String getMemberName(@Nullable TruffleStackTraceElement element) {
        if (element == null) {
            return null;
        }
        RootNode rootNode = element.getTarget().getRootNode();
        if (rootNode == null) {
            return null;
        }
        return rootNode.getName();
    }
}

